/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.filters;

import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.TableObserver;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;

public class WorkspaceColumnsObservers {
    private final GraphModel graphModel;
    private TableObserver nodesTableObserver;
    private TableObserver edgesTableObserver;

    public WorkspaceColumnsObservers(Workspace workspace) {
        this.graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
    }

    public synchronized void initialize() {
        if (this.nodesTableObserver != null) {
            return;
        }
        this.nodesTableObserver = this.graphModel.getNodeTable().createTableObserver(true);
        this.edgesTableObserver = this.graphModel.getEdgeTable().createTableObserver(true);
    }

    public synchronized void destroy() {
        if (this.nodesTableObserver != null) {
            this.nodesTableObserver.destroy();
            this.nodesTableObserver = null;
        }
        if (this.edgesTableObserver != null) {
            this.edgesTableObserver.destroy();
            this.edgesTableObserver = null;
        }
    }

    public boolean hasChanges() {
        if (this.nodesTableObserver == null) {
            return false;
        }
        boolean hasChanges = false;
        hasChanges = this.processTableObseverChanges(this.nodesTableObserver) || hasChanges;
        hasChanges = this.processTableObseverChanges(this.edgesTableObserver) || hasChanges;
        return hasChanges;
    }

    private boolean processTableObseverChanges(TableObserver observer) {
        return observer.hasTableChanged();
    }
}

