/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceMetaData;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.WorkspaceInformationImpl;
import org.gephi.project.impl.WorkspaceMetaDataImpl;
import org.gephi.project.spi.Controller;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class WorkspaceImpl
implements Workspace {
    private final transient InstanceContent instanceContent = new InstanceContent();
    private final transient Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.instanceContent);
    private final int id;
    private final ProjectImpl project;
    private final WorkspaceInformationImpl workspaceInformation;
    private final WorkspaceMetaDataImpl workspaceMetaData;

    public WorkspaceImpl(ProjectImpl project, int id) {
        this(project, id, NbBundle.getMessage(WorkspaceImpl.class, (String)"Workspace.default.prefix") + " " + id, new Object[0]);
    }

    public WorkspaceImpl(ProjectImpl project, int id, String name, Object ... objectsForLookup) {
        this.id = id;
        this.project = project;
        this.workspaceInformation = new WorkspaceInformationImpl(name);
        this.instanceContent.add((Object)this.workspaceInformation);
        for (Object o : objectsForLookup) {
            this.instanceContent.add(o);
        }
        this.workspaceMetaData = new WorkspaceMetaDataImpl();
        Lookup.getDefault().lookupAll(Controller.class).forEach(c -> {
            Object model = c.newModel(this);
            this.add(model);
        });
    }

    @Override
    public void add(Object instance) {
        this.instanceContent.add(instance);
    }

    @Override
    public void remove(Object instance) {
        this.instanceContent.remove(instance);
    }

    @Override
    public Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public ProjectImpl getProject() {
        return this.project;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isOpen() {
        return this.workspaceInformation.isOpen();
    }

    @Override
    public boolean isClosed() {
        return this.workspaceInformation.isClosed();
    }

    @Override
    public boolean isInvalid() {
        return this.workspaceInformation.isInvalid();
    }

    protected void close() {
        this.workspaceInformation.close();
    }

    protected void open() {
        this.workspaceInformation.open();
    }

    @Override
    public String getName() {
        return ((WorkspaceInformationImpl)this.lookup.lookup(WorkspaceInformationImpl.class)).getName();
    }

    @Override
    public boolean hasSource() {
        return this.workspaceInformation.hasSource();
    }

    @Override
    public String getSource() {
        return this.workspaceInformation.getSource();
    }

    @Override
    public WorkspaceMetaData getWorkspaceMetadata() {
        return this.workspaceMetaData;
    }

    public String toString() {
        WorkspaceInformationImpl information = (WorkspaceInformationImpl)this.lookup.lookup(WorkspaceInformationImpl.class);
        if (information != null) {
            return information.getName();
        }
        return "null";
    }
}

