/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ValuedAIObject;
import net.sf.freecol.server.ai.mission.TransportMission;

public abstract class TransportableAIObject
extends ValuedAIObject {
    public static final int IMPORTANT_DELIVERY = 110;
    public static final int FULL_DELIVERY = 100;
    public static final int TOOLS_FOR_COLONY_PRIORITY = 10;
    public static final int TOOLS_FOR_IMPROVEMENT = 10;
    public static final int TOOLS_FOR_PIONEER = 90;
    public static final int TOOLS_FOR_BUILDING = 100;
    private AIUnit transport;
    private static final String TRANSPORT_TAG = "transport";

    public TransportableAIObject(AIMain aiMain, String id) {
        super(aiMain, id);
        this.transport = null;
    }

    public TransportableAIObject(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
    }

    public int getTransportPriority() {
        return this.getValue();
    }

    public void setTransportPriority(int transportPriority) {
        this.setValue(transportPriority);
    }

    public final void incrementTransportPriority() {
        this.setValue(this.getValue() + 1);
    }

    public final AIUnit getTransport() {
        return this.transport;
    }

    public final void setTransport(AIUnit transport) {
        this.transport = transport;
    }

    public int getSpaceTaken() {
        Locatable l = this.getTransportLocatable();
        return l == null ? 0 : l.getSpaceTaken();
    }

    public boolean dropTransport() {
        AIUnit transport = this.getTransport();
        if (transport != null) {
            TransportMission tm;
            if (!transport.isDisposed() && this.getLocation() != transport.getUnit() && (tm = transport.getMission(TransportMission.class)) != null) {
                tm.removeTransportable(this);
            }
            this.setTransport(null);
        }
        return this.getTransport() == null;
    }

    public boolean changeTransport(AIUnit aiCarrier) {
        Location now;
        Locatable l = this.getTransportLocatable();
        if (l != null && (now = l.getLocation()) instanceof Unit && (aiCarrier == null || aiCarrier.getUnit() != now) && !this.leaveTransport()) {
            return false;
        }
        AIUnit old = this.getTransport();
        if (old != null) {
            if (old == aiCarrier) {
                return true;
            }
            TransportMission tm = old.getMission(TransportMission.class);
            if (tm != null) {
                tm.removeTransportable(this);
            }
        }
        this.setTransport(null);
        if (aiCarrier != null) {
            this.setTransport(aiCarrier);
        }
        return true;
    }

    public Location getLocation() {
        Locatable l = this.getTransportLocatable();
        return l == null ? null : l.getLocation();
    }

    public abstract Locatable getTransportLocatable();

    public abstract Location getTransportSource();

    public abstract Location getTransportDestination();

    public abstract void setTransportDestination(Location var1);

    public abstract PathNode getDeliveryPath(Unit var1, Location var2);

    public abstract PathNode getIntermediatePath(Unit var1, Location var2);

    public abstract boolean carriableBy(Unit var1);

    public abstract boolean canMove();

    public abstract boolean leaveTransport();

    public abstract boolean leaveTransport(Direction var1);

    public abstract boolean joinTransport(Unit var1, Direction var2);

    public abstract String invalidReason();

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        Unit u;
        super.writeAttributes(xw);
        if (this.transport != null && (u = this.transport.getUnit()) != null && !u.isDisposed()) {
            xw.writeAttribute(TRANSPORT_TAG, u);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        this.transport = xr.hasAttribute(TRANSPORT_TAG) ? xr.makeAIObject(aiMain, TRANSPORT_TAG, AIUnit.class, null, true) : null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TransportableAIObject)) {
            return false;
        }
        TransportableAIObject other = (TransportableAIObject)o;
        return Utils.equals(this.transport, other.transport) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return 37 * hash + Utils.hashCode(this.transport);
    }
}

