/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.UnitChangeType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class UnitChangeTypeTest
extends FreeColTestCase {
    private static final UnitType farmer = UnitChangeTypeTest.spec().getUnitType("model.unit.expertFarmer");

    public void testEmptyScope() {
        UnitChangeType uct = UnitChangeTypeTest.spec().getUnitChangeType("model.unitChange.education");
        UnitChangeTypeTest.assertEquals((String)"Education has no scopes", (int)0, (int)CollectionUtils.count(uct.getScopes()));
        for (Player player : UnitChangeTypeTest.getStandardGame().getPlayerList(CollectionUtils.alwaysTrue())) {
            UnitChangeTypeTest.assertTrue((String)"Empty scopes apply to all players", (boolean)uct.appliesTo(player));
        }
    }

    public void testAbilityScope() {
        Game game = UnitChangeTypeTest.getStandardGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Player inca = game.getPlayerByNationId("model.nation.inca");
        UnitType gardenerType = new UnitType("gardener", UnitChangeTypeTest.spec());
        gardenerType.setSkill(0);
        UnitChangeTypeTest.assertNull((Object)gardenerType.getTeachingType(farmer));
        this.addUnitTypeChange("model.unitChange.education", gardenerType, farmer, 100, -1);
        UnitChangeTypeTest.assertEquals((Object)farmer, (Object)gardenerType.getTeachingType(farmer));
        Scope scope = new Scope();
        scope.setAbilityId("model.ability.native");
        UnitChangeTypeTest.spec().getUnitChangeType("model.unitChange.education").addScope(scope);
        UnitChangeTypeTest.assertEquals((Object)farmer, (Object)gardenerType.getTeachingType(farmer));
        ServerUnit gardenerUnit = new ServerUnit(game, null, dutch, gardenerType);
        UnitChangeTypeTest.assertNull((Object)gardenerUnit.getTeachingType(farmer));
        scope.setMatchNegated(true);
        UnitChangeTypeTest.assertEquals((Object)farmer, (Object)gardenerUnit.getTeachingType(farmer));
        UnitChangeTypeTest.spec().getUnitChangeType("model.unitChange.education").removeScope(scope);
        UnitChangeTypeTest.spec().getUnitChangeType("model.unitChange.education").deleteUnitChanges(gardenerType);
    }

    public void testCreation() {
        Game game = UnitChangeTypeTest.getStandardGame();
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        UnitType gardenerType = new UnitType("gardener", UnitChangeTypeTest.spec());
        UnitChangeTypeTest.assertEquals((int)0, (int)CollectionUtils.count(UnitChangeTypeTest.spec().getUnitChanges("model.unitChange.creation", gardenerType)));
        this.addUnitTypeChange("model.unitChange.creation", gardenerType, farmer, 100, -1);
        UnitChangeTypeTest.assertEquals((int)1, (int)CollectionUtils.count(UnitChangeTypeTest.spec().getUnitChanges("model.unitChange.creation", gardenerType)));
        UnitChangeTypeTest.assertNotNull((Object)UnitChangeTypeTest.spec().getUnitChange("model.unitChange.creation", gardenerType));
        UnitChangeTypeTest.assertNotNull((Object)UnitChangeTypeTest.spec().getUnitChange("model.unitChange.creation", gardenerType, farmer));
        ServerUnit gardenerUnit = new ServerUnit(game, null, dutch, gardenerType);
        UnitChangeTypeTest.assertEquals((Object)farmer, (Object)gardenerUnit.getType());
        UnitChangeTypeTest.spec().getUnitChangeType("model.unitChange.creation").deleteUnitChanges(gardenerType);
    }
}

