/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLSequenceCharacterIterator;

public class SQLWordBreakIterator
extends BreakIterator {
    private static final Run WHITESPACE = new Whitespace();
    private static final Run DELIMITER = new LineDelimiter();
    private static final Run IDENTIFIER = new SQLIdentifier();
    private static final Run OTHER = new Other();
    protected final BreakIterator iterator = BreakIterator.getWordInstance();
    protected CharSequence text;
    private int index = this.iterator.current();

    public CharSequence getTextValue() {
        return this.text;
    }

    @Override
    public int current() {
        return this.index;
    }

    @Override
    public int first() {
        this.index = this.iterator.first();
        return this.index;
    }

    @Override
    public int following(int offset) {
        if (offset == this.getText().getEndIndex()) {
            return -1;
        }
        int next = this.iterator.following(offset);
        if (next == -1) {
            return -1;
        }
        Run run = this.consumeRun(offset);
        return offset + run.length;
    }

    private Run consumeRun(int offset) {
        char ch = this.text.charAt(offset);
        int length = this.text.length();
        Run run = this.getRun(ch);
        while (run.consume(ch) && offset < length - 1) {
            ch = this.text.charAt(++offset);
        }
        return run;
    }

    private Run getRun(char ch) {
        Run run;
        if (WHITESPACE.isValid(ch)) {
            run = WHITESPACE;
        } else if (DELIMITER.isValid(ch)) {
            run = DELIMITER;
        } else if (IDENTIFIER.isValid(ch)) {
            run = IDENTIFIER;
        } else if (OTHER.isValid(ch)) {
            run = OTHER;
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        run.init();
        return run;
    }

    @Override
    public CharacterIterator getText() {
        return this.iterator.getText();
    }

    @Override
    public boolean isBoundary(int offset) {
        if (offset == this.getText().getBeginIndex()) {
            return true;
        }
        return this.following(offset - 1) == offset;
    }

    @Override
    public int last() {
        this.index = this.iterator.last();
        return this.index;
    }

    @Override
    public int next() {
        this.index = this.following(this.index);
        return this.index;
    }

    @Override
    public int next(int n) {
        return this.iterator.next(n);
    }

    @Override
    public int preceding(int offset) {
        if (offset == this.getText().getBeginIndex()) {
            return -1;
        }
        if (this.isBoundary(offset - 1)) {
            return offset - 1;
        }
        int previous = offset - 1;
        while (!this.isBoundary(previous = this.iterator.preceding(previous))) {
        }
        int last = -1;
        while (previous < offset) {
            last = previous;
            previous = this.following(previous);
        }
        return last;
    }

    @Override
    public int previous() {
        this.index = this.preceding(this.index);
        return this.index;
    }

    @Override
    public void setText(String newText) {
        this.setText((CharSequence)newText);
    }

    public void setText(CharSequence newText) {
        this.text = newText;
        this.iterator.setText(new SQLSequenceCharacterIterator(newText));
        this.first();
    }

    @Override
    public void setText(CharacterIterator newText) {
        if (!(newText instanceof CharSequence)) {
            throw new UnsupportedOperationException("CharacterIterator not supported");
        }
        this.text = (CharSequence)((Object)newText);
        this.iterator.setText(newText);
        this.first();
    }

    static final class LineDelimiter
    extends Run {
        private char state;
        private static final char INIT = '\u0000';
        private static final char EXIT = '\u0001';

        LineDelimiter() {
        }

        @Override
        protected void init() {
            super.init();
            this.state = '\u0000';
        }

        @Override
        protected boolean consume(char ch) {
            if (!this.isValid(ch) || this.state == '\u0001') {
                return false;
            }
            if (this.state == '\u0000') {
                this.state = ch;
                ++this.length;
                return true;
            }
            if (this.state != ch) {
                this.state = '\u0001';
                ++this.length;
                return true;
            }
            return false;
        }

        @Override
        protected boolean isValid(char ch) {
            return ch == '\n' || ch == '\r';
        }
    }

    static final class Other
    extends Run {
        Other() {
        }

        @Override
        protected boolean isValid(char ch) {
            return !Character.isWhitespace(ch) && !Character.isJavaIdentifierPart(ch);
        }
    }

    protected static abstract class Run {
        protected int length;

        public Run() {
            this.init();
        }

        protected boolean consume(char ch) {
            if (this.isValid(ch)) {
                ++this.length;
                return true;
            }
            return false;
        }

        protected abstract boolean isValid(char var1);

        protected void init() {
            this.length = 0;
        }
    }

    static final class SQLIdentifier
    extends Run {
        SQLIdentifier() {
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isJavaIdentifierPart(ch);
        }
    }

    static final class Whitespace
    extends Run {
        Whitespace() {
        }

        @Override
        protected boolean isValid(char ch) {
            return Character.isWhitespace(ch) && ch != '\n' && ch != '\r';
        }
    }
}

