/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.zaproxy.zap.utils.ExecutorTerminatedListener;
import org.zaproxy.zap.utils.PausableExecutorService;

public class PausableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements PausableExecutorService {
    private final ReentrantLock pauseLock = new ReentrantLock();
    private final Condition unpaused = this.pauseLock.newCondition();
    private boolean paused;
    private List<ExecutorTerminatedListener> listeners = new ArrayList<ExecutorTerminatedListener>(1);
    private long defaultDelayInMs;
    private boolean incrementalDefaultDelay;
    private AtomicInteger queuedTaskCount;

    public PausableScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public PausableScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public PausableScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public PausableScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    public void setDefaultDelay(long delay, TimeUnit unit) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Parameter delay must be greater or equal to zero.");
        }
        if (unit == null) {
            throw new IllegalArgumentException("Parameter unit must not be null.");
        }
        this.defaultDelayInMs = unit.toMillis(delay);
    }

    public long getDefaultDelay(TimeUnit unit) {
        return unit.convert(this.defaultDelayInMs, TimeUnit.MILLISECONDS);
    }

    public void setIncrementalDefaultDelay(boolean incremental) {
        if (this.incrementalDefaultDelay == incremental) {
            return;
        }
        this.incrementalDefaultDelay = incremental;
        this.queuedTaskCount = this.incrementalDefaultDelay ? new AtomicInteger() : null;
    }

    public boolean isIncrementalDefaultDelay() {
        return this.incrementalDefaultDelay;
    }

    public void resetIncrementalDefaultDelay() {
        if (this.incrementalDefaultDelay) {
            this.queuedTaskCount = new AtomicInteger();
        }
    }

    @Override
    public void execute(Runnable command) {
        this.schedule(command, this.getDefaultDelayForTask(), TimeUnit.MILLISECONDS);
    }

    private long getDefaultDelayForTask() {
        if (this.incrementalDefaultDelay) {
            return (long)this.queuedTaskCount.incrementAndGet() * this.defaultDelayInMs;
        }
        return this.defaultDelayInMs;
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.schedule(task, this.getDefaultDelayForTask(), TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.schedule(Executors.callable(task, result), this.getDefaultDelayForTask(), TimeUnit.MILLISECONDS);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.schedule(task, this.getDefaultDelayForTask(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.pauseLock.lock();
        try {
            while (this.paused) {
                this.unpaused.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (this.incrementalDefaultDelay) {
            this.queuedTaskCount.decrementAndGet();
        }
    }

    @Override
    public void pause() {
        this.pauseLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public void resume() {
        this.pauseLock.lock();
        try {
            if (!this.paused) {
                return;
            }
            this.paused = false;
            this.unpaused.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.resume();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.resume();
        return super.shutdownNow();
    }

    @Override
    protected void terminated() {
        super.terminated();
        PausableScheduledThreadPoolExecutor.notifyListeners(new ArrayList<ExecutorTerminatedListener>(this.listeners));
    }

    private static void notifyListeners(List<ExecutorTerminatedListener> listeners) {
        for (ExecutorTerminatedListener listener : listeners) {
            listener.terminated();
        }
    }

    @Override
    public void addExecutorTerminatedListener(ExecutorTerminatedListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeExecutorTerminatedListener(ExecutorTerminatedListener listener) {
        this.listeners.remove(listener);
    }
}

