/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.model.Vulnerability;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

@Deprecated(since="2.14.0", forRemoval=true)
public class VulnerabilitiesLoader {
    private static final Logger LOGGER = LogManager.getLogger(VulnerabilitiesLoader.class);
    private final Path directory;
    private final String fileName;
    private final String fileExtension;

    public VulnerabilitiesLoader(Path directory, String fileName, String fileExtension) {
        if (directory == null) {
            throw new IllegalArgumentException("Parameter directory must not be null.");
        }
        VulnerabilitiesLoader.validateNotEmpty(fileName, "Parameter fileName must not be null nor empty.");
        VulnerabilitiesLoader.validateNotEmpty(fileExtension, "Parameter fileExtension must not be null nor empty.");
        this.directory = directory;
        this.fileName = fileName;
        this.fileExtension = fileExtension;
    }

    private static void validateNotEmpty(String value, String message) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public List<Vulnerability> load(Locale locale) {
        List vulnerabilities;
        List<String> filenames = this.getListOfVulnerabilitiesFiles();
        String extension = this.fileExtension;
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if ((vulnerabilities = LocaleUtils.findResource(this.fileName, extension, locale, candidateFilename -> {
            if (filenames.contains(candidateFilename)) {
                LOGGER.debug("loading vulnerabilities from {} for locale {}", candidateFilename, (Object)locale);
                List<Vulnerability> list = this.loadVulnerabilitiesFile(this.directory.resolve((String)candidateFilename));
                if (list == null) {
                    return Collections.emptyList();
                }
                return Collections.unmodifiableList(list);
            }
            return null;
        })) == null) {
            return Collections.emptyList();
        }
        return vulnerabilities;
    }

    List<Vulnerability> loadVulnerabilitiesFile(Path file) {
        List<Vulnerability> list;
        BufferedInputStream is = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
        try {
            list = VulnerabilitiesLoader.loadVulnerabilities(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        ((InputStream)is).close();
        return list;
    }

    static List<Vulnerability> loadVulnerabilities(InputStream is) {
        String[] test;
        ZapXmlConfiguration config;
        try {
            config = new ZapXmlConfiguration(is);
        }
        catch (ConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        try {
            test = config.getStringArray("vuln_items");
        }
        catch (ConversionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        int numberOfVulns = test.length;
        ArrayList<Vulnerability> tempVulns = new ArrayList<Vulnerability>(numberOfVulns);
        for (String item : test) {
            ArrayList<String> references;
            String name = "vuln_item_" + item;
            try {
                references = new ArrayList<String>(Arrays.asList(config.getStringArray(name + ".reference")));
            }
            catch (ConversionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                references = new ArrayList(0);
            }
            Vulnerability v = new Vulnerability(item, config.getString(name + ".alert"), config.getString(name + ".desc"), config.getString(name + ".solution"), references);
            tempVulns.add(v);
        }
        return tempVulns;
    }

    List<String> getListOfVulnerabilitiesFiles() {
        if (!Files.exists(this.directory, new LinkOption[0])) {
            LOGGER.debug("Skipping read of vulnerabilities, the directory does not exist: {}", (Object)this.directory.toAbsolutePath());
            return Collections.emptyList();
        }
        final Pattern filePattern = LocaleUtils.createResourceFilesPattern(this.fileName, this.fileExtension);
        final ArrayList<String> fileNames = new ArrayList<String>();
        try {
            Files.walkFileTree(this.directory, Collections.emptySet(), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String fileName = file.getFileName().toString();
                    if (filePattern.matcher(fileName).matches()) {
                        fileNames.add(fileName);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while walking directory: {}", (Object)this.directory, (Object)e);
        }
        return fileNames;
    }
}

