import type ts from 'typescript/lib/tsserverlibrary';
import { Logger } from '../logger';
import { InternalHelpers } from 'svelte2tsx';
type _ts = typeof ts;
declare module 'typescript/lib/tsserverlibrary' {
    interface LanguageServiceHost {
        /** @internal */ getCachedExportInfoMap?(): unknown;
        /** @internal */ getModuleSpecifierCache?(): unknown;
        /** @internal */ getGlobalTypingsCacheLocation?(): string | undefined;
        /** @internal */ getSymlinkCache?(files: readonly ts.SourceFile[]): unknown;
        /** @internal */ getPackageJsonsVisibleToFile?(fileName: string, rootDir?: string): readonly unknown[];
        /** @internal */ getPackageJsonAutoImportProvider?(): ts.Program | undefined;
        /** @internal*/ getModuleResolutionCache?(): ts.ModuleResolutionCache;
        /** @internal */ useSourceOfProjectReferenceRedirect?(): boolean;
    }
}
export declare const kitExports: Record<string, {
    displayParts: ts.SymbolDisplayPart[];
    documentation: ts.SymbolDisplayPart[];
    allowedIn: Array<'server' | 'universal' | 'layout' | 'page' | 'api'>;
}>;
export declare function isKitRouteExportAllowedIn(basename: string, kitExport: (typeof kitExports)[keyof typeof kitExports]): boolean;
export declare function getVirtualLS(fileName: string, info: ts.server.PluginCreateInfo, ts: _ts, logger?: Logger): {
    languageService: ts.LanguageService;
    addedCode: InternalHelpers.AddedCode[];
    toVirtualPos: (pos: number) => number;
    toOriginalPos: (pos: number) => {
        pos: number;
        inGenerated: boolean;
    };
} | undefined;
export {};
