/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Parser {
    public static final String MONOSPACED = "monospaced";
    private static final Pattern SCALE = Pattern.compile("(?:scale=|\\*)([0-9.]+)");
    private static final Pattern COLOR = Pattern.compile("color[= :](#[0-9a-fA-F]{1,6}|\\w+)");

    public static boolean isLatexStart(String line) {
        return line.equals("<latex>");
    }

    public static boolean isLatexEnd(String line) {
        return line.equals("</latex>");
    }

    public static boolean isCodeStart(String line) {
        return line.equals("<code>");
    }

    public static boolean isCodeEnd(String line) {
        return line.equals("</code>");
    }

    public static boolean isTreeStart(String line) {
        return line.startsWith("|_");
    }

    public static double getScale(String s, double def) {
        if (s == null) {
            return def;
        }
        Matcher m = SCALE.matcher(s);
        if (m.find()) {
            return Double.parseDouble(m.group(1));
        }
        return def;
    }

    public static String getColor(String s) {
        if (s == null) {
            return null;
        }
        Matcher m = COLOR.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

