/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.StringAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class StringBufferAttributeConverter
implements AttributeConverter<StringBuffer> {
    public static final StringAttributeConverter STRING_CONVERTER = StringAttributeConverter.create();

    public static StringBufferAttributeConverter create() {
        return new StringBufferAttributeConverter();
    }

    @Override
    public EnhancedType<StringBuffer> type() {
        return EnhancedType.of(StringBuffer.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(StringBuffer input) {
        return STRING_CONVERTER.transformFrom(input.toString());
    }

    @Override
    public StringBuffer transformTo(AttributeValue input) {
        return new StringBuffer(STRING_CONVERTER.transformTo(input));
    }
}

