/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.api.internal.backoff;

import java.time.Duration;
import java.util.Random;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.internal.backoff.BackoffStrategiesConstants;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class FixedDelayWithJitter
implements BackoffStrategy {
    private final Supplier<Random> randomSupplier;
    private final Duration delay;

    public FixedDelayWithJitter(Supplier<Random> randomSupplier, Duration delay) {
        this.randomSupplier = (Supplier)Validate.paramNotNull(randomSupplier, (String)"random");
        this.delay = NumericUtils.min((Duration)Validate.isPositive((Duration)delay, (String)"delay"), (Duration)BackoffStrategiesConstants.BASE_DELAY_CEILING);
    }

    @Override
    public Duration computeDelay(int attempt) {
        Validate.isPositive((int)attempt, (String)"attempt");
        return Duration.ofMillis(this.randomSupplier.get().nextInt((int)this.delay.toMillis()));
    }

    public String toString() {
        return ToString.builder((String)"FixedDelayWithJitter").add("delay", (Object)this.delay).build();
    }
}

