/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.engine.states.creation;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.UpdateNextExecutionTimeResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.SMResult;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.State;
import org.opensearch.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMMetadata;
import org.opensearch.indexmanagement.snapshotmanagement.model.SMPolicy;
import org.opensearch.jobscheduler.spi.schedule.Schedule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/creation/CreationConditionMetState;", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/State;", "<init>", "()V", "continuous", "", "getContinuous", "()Z", "execute", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/states/SMResult;", "context", "Lorg/opensearch/indexmanagement/snapshotmanagement/engine/SMStateMachine;", "(Lorg/opensearch/indexmanagement/snapshotmanagement/engine/SMStateMachine;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nCreationConditionMetState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreationConditionMetState.kt\norg/opensearch/indexmanagement/snapshotmanagement/engine/states/creation/CreationConditionMetState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class CreationConditionMetState
implements State {
    @NotNull
    public static final CreationConditionMetState INSTANCE = new CreationConditionMetState();
    private static final boolean continuous = true;

    private CreationConditionMetState() {
    }

    @Override
    public boolean getContinuous() {
        return continuous;
    }

    @Nullable
    public Object execute(@NotNull SMStateMachine context, @NotNull Continuation<? super SMResult> $completion) {
        SMMetadata.Builder metadataBuilder;
        block5: {
            Instant nextCreationTime;
            Instant instant;
            SMPolicy job = context.getJob();
            SMMetadata metadata2 = context.getMetadata();
            Logger log = context.getLog();
            metadataBuilder = null;
            metadataBuilder = new SMMetadata.Builder(metadata2).workflow(WorkflowType.CREATION);
            if (job.getCreation() == null) {
                log.warn("Policy creation config becomes null before trying to create snapshot. Reset.");
                return new SMResult.Fail(metadataBuilder.resetCreation(), WorkflowType.CREATION, Boxing.boxBoolean((boolean)true));
            }
            if (metadata2.getCreation() == null) {
                Instant nextTime;
                Instant instant2 = nextTime = job.getCreation().getSchedule().getNextExecutionTime(Instant.now());
                if (instant2 != null) {
                    Instant it = instant2;
                    boolean bl = false;
                    metadataBuilder.setNextCreationTime(it);
                }
                instant = nextTime;
            } else {
                instant = metadata2.getCreation().getTrigger().getTime();
            }
            Instant instant3 = nextCreationTime = instant;
            if (instant3 == null) break block5;
            Instant creationTime = instant3;
            boolean bl = false;
            Schedule schedule = job.getCreation().getSchedule();
            boolean bl2 = false;
            UpdateNextExecutionTimeResult updateNextTimeResult = SMUtilsKt.tryUpdatingNextExecutionTime(metadataBuilder, creationTime, schedule, WorkflowType.CREATION, log);
            if (!updateNextTimeResult.getUpdated()) {
                return new SMResult.Stay(metadataBuilder);
            }
            metadataBuilder = updateNextTimeResult.getMetadataBuilder();
        }
        return new SMResult.Next(metadataBuilder);
    }
}

