"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WORKFLOW_BASE_API = exports.MONITOR_BASE_API = exports.EMAIL_GROUP_BASE_API = exports.EMAIL_ACCOUNT_BASE_API = exports.DESTINATION_BASE_API = exports.DEFAULT_HEADERS = exports.CROSS_CLUSTER_BASE_API = exports.COMMENTS_BASE_API = exports.CLUSTER = exports.API_ROUTE_PREFIX = exports.AD_BASE_API = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const API_ROUTE_PREFIX = exports.API_ROUTE_PREFIX = '/_plugins/_alerting';
const MONITOR_BASE_API = exports.MONITOR_BASE_API = `${API_ROUTE_PREFIX}/monitors`;
const COMMENTS_BASE_API = exports.COMMENTS_BASE_API = `${API_ROUTE_PREFIX}/comments`;
const WORKFLOW_BASE_API = exports.WORKFLOW_BASE_API = `${API_ROUTE_PREFIX}/workflows`;
const CROSS_CLUSTER_BASE_API = exports.CROSS_CLUSTER_BASE_API = `${API_ROUTE_PREFIX}/remote`;
const AD_BASE_API = exports.AD_BASE_API = `/_plugins/_anomaly_detection/detectors`;
const DESTINATION_BASE_API = exports.DESTINATION_BASE_API = `${API_ROUTE_PREFIX}/destinations`;
const EMAIL_ACCOUNT_BASE_API = exports.EMAIL_ACCOUNT_BASE_API = `${DESTINATION_BASE_API}/email_accounts`;
const EMAIL_GROUP_BASE_API = exports.EMAIL_GROUP_BASE_API = `${DESTINATION_BASE_API}/email_groups`;
const DEFAULT_HEADERS = exports.DEFAULT_HEADERS = {
  'Content-Type': 'application/json',
  Accept: 'application/json',
  'User-Agent': 'OpenSearch-Dashboards'
};
const CLUSTER = exports.CLUSTER = {
  ADMIN: 'admin',
  ALERTING: 'opensearch_alerting',
  AD_ALERTING: 'alerting_ad',
  DATA: 'data'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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