/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.ffmpeg.ImageFormat;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public enum ImageFormats implements ImageFormat
{
    BGR24("bgr24", 3, new byte[]{66, 71, 82, 24}, 5, new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0), new int[]{2, 1, 0}),
    ABGR("abgr", 4, new byte[]{65, 66, 71, 82}, 6, new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0), new int[]{3, 2, 1, 0});

    private final String pixelFormat;
    private final int bytesPerPixel;
    private final byte[] fourcc;
    private final int imageType;
    private final ComponentColorModel componentColorModel;
    private final int[] bOffs;

    private ImageFormats(String pixelFormat, int bytesPerPixel, byte[] fourcc, int imageType, ComponentColorModel componentColorModel, int[] bOffs) {
        this.pixelFormat = pixelFormat;
        this.bytesPerPixel = bytesPerPixel;
        this.fourcc = fourcc;
        this.imageType = imageType;
        this.componentColorModel = componentColorModel;
        this.bOffs = bOffs;
    }

    @Override
    public String getPixelFormat() {
        return this.pixelFormat;
    }

    @Override
    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    @Override
    public byte[] getFourCC() {
        return (byte[])this.fourcc.clone();
    }

    @Override
    public BufferedImage toImage(byte[] data, int width, int height) {
        int expectedLength = width * height * this.bytesPerPixel;
        if (data.length != expectedLength) {
            throw new JaffreeException("Not enough bytes: " + data.length + ", expected " + expectedLength);
        }
        DataBufferByte buffer = new DataBufferByte(data, data.length);
        WritableRaster raster = Raster.createInterleavedRaster(buffer, width, height, width * this.bytesPerPixel, this.bytesPerPixel, this.bOffs, null);
        return new BufferedImage(this.componentColorModel, raster, false, null);
    }

    @Override
    public byte[] toBytes(BufferedImage image) {
        if (image.getType() != this.imageType) {
            throw new JaffreeException("Wrong image type: " + image.getType() + ", expected: " + this.imageType);
        }
        return ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
    }
}

