/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.ikonli.swing;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kordamp.ikonli.FontLoader;
import org.kordamp.ikonli.IkonHandler;
import org.osgi.service.component.annotations.Component;

@Component(service={FontLoader.class})
public class SwingFontLoader
implements FontLoader {
    private static final Map<String, Font> FONTS = new ConcurrentHashMap<String, Font>();

    public void loadFont(IkonHandler handler) {
        String fontResource = handler.getFontResource().toExternalForm();
        Font font = FONTS.computeIfAbsent(fontResource, key -> {
            Font font;
            block9: {
                InputStream stream = handler.getFontResourceAsStream();
                try {
                    if (stream == null) {
                        throw new IllegalStateException("Font resource not found: " + fontResource);
                    }
                    Font newFont = Font.createFont(0, stream);
                    GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(newFont);
                    font = newFont;
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FontFormatException | IOException e) {
                        throw new IllegalStateException("Failed to load font from " + fontResource, e);
                    }
                }
                stream.close();
            }
            return font;
        });
        handler.setFont((Object)font);
    }

    public static FontLoader getInstance() {
        return new SwingFontLoader();
    }
}

