/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.sessions.AuthenticationSessionModel;

public class AuthenticationFlowResolver {
    private static final Logger logger = Logger.getLogger(AuthenticationFlowResolver.class);

    public static AuthenticationFlowModel resolveBrowserFlow(AuthenticationSessionModel authSession) {
        AuthenticationFlowModel flow = null;
        ClientModel client = authSession.getClient();
        String requestedFlowAlias = authSession.getAuthNote("requested-authentication-flow");
        if (requestedFlowAlias != null) {
            flow = authSession.getRealm().getFlowByAlias(requestedFlowAlias);
            if (flow == null) {
                throw new ModelException("Client " + client.getClientId() + " has requested browser flow " + requestedFlowAlias + ", but this flow does not exist.");
            }
            return flow;
        }
        String clientFlow = client.getAuthenticationFlowBindingOverride("browser");
        if (clientFlow != null) {
            flow = authSession.getRealm().getAuthenticationFlowById(clientFlow);
            if (flow != null) {
                return flow;
            }
            logger.warnf("Client %s has browser flow override, but this flow '%s' does not exist, fallback to browser flow", (Object)client.getClientId(), (Object)clientFlow);
        }
        return authSession.getRealm().getBrowserFlow();
    }

    public static AuthenticationFlowModel resolveDirectGrantFlow(AuthenticationSessionModel authSession) {
        AuthenticationFlowModel flow = null;
        ClientModel client = authSession.getClient();
        String requestedFlowAlias = authSession.getAuthNote("requested-authentication-flow");
        if (requestedFlowAlias != null) {
            flow = authSession.getRealm().getFlowByAlias(requestedFlowAlias);
            if (flow == null) {
                throw new ModelException("Client " + client.getClientId() + " has requested browser flow " + requestedFlowAlias + ", but this flow does not exist.");
            }
            return flow;
        }
        String clientFlow = client.getAuthenticationFlowBindingOverride("direct_grant");
        if (clientFlow != null) {
            flow = authSession.getRealm().getAuthenticationFlowById(clientFlow);
            if (flow != null) {
                return flow;
            }
            logger.warnf("Client %s has direct grant flow override, but this flow '%s' does not exist, fallback to direct grant flow", (Object)client.getClientId(), (Object)clientFlow);
        }
        return authSession.getRealm().getDirectGrantFlow();
    }
}

