/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.webauthn4j.data.attestation.statement.AttestationCertificatePath;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.attestation.statement.CertificateBaseAttestationStatement;
import com.webauthn4j.data.attestation.statement.TPMSAttest;
import com.webauthn4j.data.attestation.statement.TPMTPublic;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.exception.ConstraintViolationException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(value={"format"})
@JsonTypeName(value="tpm")
public class TPMAttestationStatement
implements CertificateBaseAttestationStatement {
    public static final String FORMAT = "tpm";
    public static final String VERSION_2_0 = "2.0";
    @JsonProperty
    private final String ver;
    @JsonProperty
    private final COSEAlgorithmIdentifier alg;
    @JsonProperty
    private final AttestationCertificatePath x5c;
    @JsonProperty
    private final byte[] sig;
    @JsonProperty
    private final TPMSAttest certInfo;
    @JsonProperty
    private final TPMTPublic pubArea;

    public TPMAttestationStatement(@JsonProperty(value="ver") @NotNull String ver, @JsonProperty(value="alg") @NotNull COSEAlgorithmIdentifier alg, @JsonProperty(value="x5c") @Nullable AttestationCertificatePath x5c, @JsonProperty(value="sig") @NotNull byte[] sig, @JsonProperty(value="certInfo") @NotNull TPMSAttest certInfo, @JsonProperty(value="pubArea") @NotNull TPMTPublic pubArea) {
        AssertUtil.notNull(ver, "ver must not be null");
        AssertUtil.notNull(alg, "alg must not be null");
        AssertUtil.notNull(sig, "sig must not be null");
        AssertUtil.notNull(certInfo, "certInfo must not be null");
        AssertUtil.notNull(pubArea, "pubArea must not be null");
        this.ver = ver;
        this.alg = alg;
        this.x5c = x5c;
        this.sig = sig;
        this.certInfo = certInfo;
        this.pubArea = pubArea;
    }

    public TPMAttestationStatement(@NotNull COSEAlgorithmIdentifier alg, @NotNull AttestationCertificatePath x5c, @NotNull byte[] sig, @NotNull TPMSAttest certInfo, @NotNull TPMTPublic pubArea) {
        this(VERSION_2_0, alg, x5c, sig, certInfo, pubArea);
    }

    @NotNull
    public String getVer() {
        return this.ver;
    }

    @NotNull
    public COSEAlgorithmIdentifier getAlg() {
        return this.alg;
    }

    @Override
    @Nullable
    public AttestationCertificatePath getX5c() {
        return this.x5c;
    }

    @NotNull
    public byte[] getSig() {
        return ArrayUtil.clone(this.sig);
    }

    @NotNull
    public TPMSAttest getCertInfo() {
        return this.certInfo;
    }

    @NotNull
    public TPMTPublic getPubArea() {
        return this.pubArea;
    }

    @Override
    @NotNull
    public String getFormat() {
        return FORMAT;
    }

    @Override
    public void validate() {
        if (this.x5c.isEmpty()) {
            throw new ConstraintViolationException("x5c must not be empty");
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMAttestationStatement that = (TPMAttestationStatement)o;
        return Objects.equals(this.ver, that.ver) && Objects.equals(this.alg, that.alg) && Objects.equals(this.x5c, that.x5c) && Arrays.equals(this.sig, that.sig) && Objects.equals(this.certInfo, that.certInfo) && Objects.equals(this.pubArea, that.pubArea);
    }

    public int hashCode() {
        int result = Objects.hash(this.ver, this.alg, this.x5c, this.certInfo, this.pubArea);
        result = 31 * result + Arrays.hashCode(this.sig);
        return result;
    }
}

