/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.deployment.filter;

import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

public class AutoAddOpenApiEndpointFilter
implements OASFilter {
    private static final String OPENAPI_TAG = "openapi";
    private static final String ENDPOINT_DESCRIPTION = "OpenAPI specification";
    private final String path;

    public AutoAddOpenApiEndpointFilter(String path) {
        this.path = path;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        if (paths == null) {
            paths = OASFactory.createPaths();
            openAPI.setPaths(paths);
        }
        openAPI.addTag(OASFactory.createTag().name(OPENAPI_TAG));
        this.createPathItem(paths, "", MediaTypeForEndpoint.BOTH);
        this.createPathItem(paths, "Json", MediaTypeForEndpoint.JSON);
        this.createPathItem(paths, "Yaml", MediaTypeForEndpoint.YAML);
        this.createPathItem(paths, "Yml", MediaTypeForEndpoint.YAML);
    }

    private void createPathItem(Paths paths, String suffix, MediaTypeForEndpoint mediaTypeForEndpoints) {
        Content openApiContent = OASFactory.createContent();
        if (mediaTypeForEndpoints == MediaTypeForEndpoint.JSON || mediaTypeForEndpoints == MediaTypeForEndpoint.BOTH) {
            openApiContent.addMediaType("application/json", OASFactory.createMediaType());
        }
        if (mediaTypeForEndpoints == MediaTypeForEndpoint.YAML || mediaTypeForEndpoints == MediaTypeForEndpoint.BOTH) {
            openApiContent.addMediaType("application/yaml", OASFactory.createMediaType());
        }
        APIResponses openApiResponse = OASFactory.createAPIResponses().addAPIResponse("200", OASFactory.createAPIResponse().description(ENDPOINT_DESCRIPTION).content(openApiContent));
        Object pathItemPath = this.path;
        if (!suffix.isEmpty()) {
            pathItemPath = (String)pathItemPath + "." + suffix.toLowerCase();
        }
        PathItem pathItem = OASFactory.createPathItem().GET(OASFactory.createOperation().description(ENDPOINT_DESCRIPTION).addTag(OPENAPI_TAG).operationId("getOpenAPISpecification" + suffix).responses(openApiResponse));
        paths.addPathItem((String)pathItemPath, pathItem);
    }

    private static enum MediaTypeForEndpoint {
        JSON,
        YAML,
        BOTH;

    }
}

