/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.sf.juife.DefaultNavigationHistoryModel;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.AbstractInstrumentsDbTree;
import org.jsampler.view.DbDirectoryTreeNode;
import org.jsampler.view.InstrumentsDbTreeModel;
import org.jsampler.view.std.StdI18n;

public class JSInstrumentsDbTree
extends AbstractInstrumentsDbTree {
    public final AbstractAction actionGoUp = new GoUp();
    public final AbstractAction actionGoBack = new GoBack();
    public final AbstractAction actionGoForward = new GoForward();
    private final NavigationHistoryModel navigationHistoryModel = new NavigationHistoryModel();

    public JSInstrumentsDbTree(InstrumentsDbTreeModel instrumentsDbTreeModel) {
        super(instrumentsDbTreeModel);
        CellRenderer cellRenderer = new CellRenderer();
        this.setCellRenderer(cellRenderer);
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 0));
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 3) {
                    return;
                }
                JSInstrumentsDbTree.this.setSelectionPath(JSInstrumentsDbTree.this.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
            }
        });
        ContextMenu contextMenu = new ContextMenu();
        this.installKeyboardListeners();
        CC.addInstrumentsDbChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSInstrumentsDbTree.this.setModel(CC.getInstrumentsDbTreeModel());
                CC.scheduleInTaskQueue(new Runnable(){

                    @Override
                    public void run() {
                        JSInstrumentsDbTree.this.setSelectedDirectory("/");
                        JSInstrumentsDbTree.this.navigationHistoryModel.clearHistory();
                    }
                });
            }
        });
        this.addTreeSelectionListener((GoUp)this.actionGoUp);
        this.addTreeSelectionListener(this.navigationHistoryModel);
    }

    private void installKeyboardListeners() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        abstractAction.setEnabled(false);
        this.getActionMap().put("none", abstractAction);
        int n = CC.getViewConfig().getDefaultModKey();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(88, n), "none");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(86, n), "none");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(88, n), "none");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(86, n), "none");
    }

    public NavigationHistoryModel getNavigationHistoryModel() {
        return this.navigationHistoryModel;
    }

    class ContextMenu
    extends MouseAdapter {
        private final JPopupMenu cmenu = new JPopupMenu();
        JMenuItem miEdit = new JMenuItem(StdI18n.i18n.getMenuLabel("ContextMenu.edit"));

        ContextMenu() {
            this.cmenu.add(this.miEdit);
            this.miEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            JMenuItem jMenuItem = new JMenuItem(StdI18n.i18n.getMenuLabel("ContextMenu.delete"));
            this.cmenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSInstrumentsDbTree.this.removeSelectedDirectory();
                }
            });
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.show(mouseEvent);
            }
        }

        void show(MouseEvent mouseEvent) {
            this.cmenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        CellRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            DbDirectoryTreeNode dbDirectoryTreeNode = (DbDirectoryTreeNode)object;
            if (dbDirectoryTreeNode.getInfo().getName() == "/") {
                this.setIcon(JSInstrumentsDbTree.this.getView().getRootIcon());
            } else if (bl3) {
                this.setIcon(JSInstrumentsDbTree.this.getView().getInstrumentIcon());
            } else if (bl2) {
                this.setIcon(JSInstrumentsDbTree.this.getView().getOpenIcon());
            } else {
                this.setIcon(JSInstrumentsDbTree.this.getView().getClosedIcon());
            }
            String string = dbDirectoryTreeNode.getInfo().getDescription();
            if (string != null && string.length() > 0) {
                this.setToolTipText(string);
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }

    private class GoForward
    extends AbstractAction {
        GoForward() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.go.forward"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.go.forward.tt");
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", CC.getViewConfig().getBasicIconSet().getForward16Icon());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSInstrumentsDbTree.this.navigationHistoryModel.goForward();
        }
    }

    private class GoBack
    extends AbstractAction {
        GoBack() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.go.back"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.go.back.tt");
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", CC.getViewConfig().getBasicIconSet().getBack16Icon());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSInstrumentsDbTree.this.navigationHistoryModel.goBack();
        }
    }

    private class GoUp
    extends AbstractAction
    implements TreeSelectionListener {
        GoUp() {
            super(StdI18n.i18n.getMenuLabel("instrumentsdb.go.up"));
            String string = StdI18n.i18n.getMenuLabel("instrumentsdb.go.up.tt");
            this.putValue("ShortDescription", string);
            this.putValue("SmallIcon", CC.getViewConfig().getBasicIconSet().getUp16Icon());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTree.this.getSelectedDirectoryNode();
            if (dbDirectoryTreeNode == null) {
                return;
            }
            JSInstrumentsDbTree.this.setSelectedDirectoryNode(dbDirectoryTreeNode.getParent());
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            DbDirectoryTreeNode dbDirectoryTreeNode = JSInstrumentsDbTree.this.getSelectedDirectoryNode();
            if (dbDirectoryTreeNode == null) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(dbDirectoryTreeNode.getParent() != null);
        }
    }

    private class NavigationHistoryModel
    extends DefaultNavigationHistoryModel<DbDirectoryTreeNode>
    implements TreeSelectionListener,
    ActionListener {
        private boolean lock = false;

        NavigationHistoryModel() {
            this.addActionListener(this);
        }

        @Override
        public DbDirectoryTreeNode goBack() {
            this.lock = true;
            DbDirectoryTreeNode dbDirectoryTreeNode = this.selectDirectory((DbDirectoryTreeNode)super.goBack());
            this.lock = false;
            return dbDirectoryTreeNode;
        }

        @Override
        public DbDirectoryTreeNode goForward() {
            this.lock = true;
            DbDirectoryTreeNode dbDirectoryTreeNode = this.selectDirectory((DbDirectoryTreeNode)super.goForward());
            this.lock = false;
            return dbDirectoryTreeNode;
        }

        private DbDirectoryTreeNode selectDirectory(DbDirectoryTreeNode dbDirectoryTreeNode) {
            if (dbDirectoryTreeNode == null) {
                return null;
            }
            String string = dbDirectoryTreeNode.getInfo().getDirectoryPath();
            if (CC.getInstrumentsDbTreeModel().getNodeByPath(string) != null) {
                JSInstrumentsDbTree.this.setSelectedDirectory(string);
                return dbDirectoryTreeNode;
            }
            this.removePage();
            this.fireActionPerformed();
            String string2 = StdI18n.i18n.getMessage("JSInstrumentsDbTree.unknownDirectory!", string);
            HF.showErrorMessage(string2, JSInstrumentsDbTree.this);
            return dbDirectoryTreeNode;
        }

        @Override
        public void addPage(DbDirectoryTreeNode dbDirectoryTreeNode) {
            if (this.lock) {
                return;
            }
            if (dbDirectoryTreeNode == null) {
                return;
            }
            super.addPage(dbDirectoryTreeNode);
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.addPage(JSInstrumentsDbTree.this.getSelectedDirectoryNode());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSInstrumentsDbTree.this.actionGoBack.setEnabled(this.hasBack());
            JSInstrumentsDbTree.this.actionGoForward.setEnabled(this.hasForward());
        }
    }
}

