/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.plan.registry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.editors.sql.plan.registry.SQLPlanViewDescriptor;

public class SQLPlanViewRegistry {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sql.plan.view";
    private static final String TAG_VIEW = "view";
    private static SQLPlanViewRegistry instance;
    private List<SQLPlanViewDescriptor> planViewDescriptors = new ArrayList<SQLPlanViewDescriptor>();

    public static synchronized SQLPlanViewRegistry getInstance() {
        if (instance == null) {
            instance = new SQLPlanViewRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLPlanViewRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] panelElements;
        for (IConfigurationElement ext : panelElements = registry.getConfigurationElementsFor(EXTENSION_ID)) {
            if (!TAG_VIEW.equals(ext.getName())) continue;
            SQLPlanViewDescriptor descriptor = new SQLPlanViewDescriptor(ext);
            this.planViewDescriptors.add(descriptor);
        }
    }

    @NotNull
    public List<SQLPlanViewDescriptor> getPlanViewDescriptors() {
        ArrayList<SQLPlanViewDescriptor> result = new ArrayList<SQLPlanViewDescriptor>(this.planViewDescriptors);
        result.sort(Comparator.comparingInt(SQLPlanViewDescriptor::getPriority));
        return result;
    }

    @Nullable
    public SQLPlanViewDescriptor getPlanViewDescriptor(String id) {
        for (SQLPlanViewDescriptor converter : this.planViewDescriptors) {
            if (!converter.getId().equals(id)) continue;
            return converter;
        }
        return null;
    }
}

