/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;

public record LSMAnalyzerParameters(@NotNull Map<String, String> knownIdentifierQuotes, boolean isSqlParametersEnabled, boolean isAnonymousSqlParametersEnabled, char anonymousParameterMark, @NotNull List<Map.Entry<Integer, Set<String>>> namedParameterPrefixes, boolean variablesEnabled) {
    public static LSMAnalyzerParameters forDialect(SQLDialect dialect, SQLSyntaxManager syntaxManager) {
        Map<String, String> identifierQuotPairs = Stream.of(Objects.requireNonNull(dialect.getIdentifierQuoteStrings())).collect(Collectors.toUnmodifiableMap(q -> q[0], q -> q[1]));
        List<Map.Entry<Integer, Set<String>>> namedParameterPrefixes = Stream.of(Objects.requireNonNull(syntaxManager.getNamedParameterPrefixes())).collect(Collectors.groupingBy(String::length, Collectors.toSet())).entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).collect(Collectors.toList());
        return new LSMAnalyzerParameters(identifierQuotPairs, syntaxManager.isParametersEnabled(), syntaxManager.isAnonymousParametersEnabled(), syntaxManager.getAnonymousParameterMark(), namedParameterPrefixes, syntaxManager.isVariablesEnabled());
    }
}

