/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;
import javax.security.auth.Subject;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre19Compat;
import org.apache.tomcat.util.res.StringManager;

public class Jre21Compat
extends Jre19Compat {
    private static final Log log = LogFactory.getLog(Jre21Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre21Compat.class);
    private static final boolean supported;
    private static final Method nameMethod;
    private static final Method startMethod;
    private static final Method ofVirtualMethod;
    private static final Method callAsMethod;

    static boolean isSupported() {
        return supported;
    }

    @Override
    public Object createVirtualThreadBuilder(String string) {
        try {
            Object object = ofVirtualMethod.invoke(null, (Object[])null);
            nameMethod.invoke(object, string, 0L);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    @Override
    public void threadBuilderStart(Object object, Runnable runnable) {
        try {
            startMethod.invoke(object, runnable);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    @Override
    public <T> T callAs(Subject subject, Callable<T> callable) throws CompletionException {
        try {
            return (T)callAsMethod.invoke(null, subject, callable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CompletionException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof CompletionException) {
                throw (CompletionException)throwable;
            }
            throw new CompletionException(invocationTargetException);
        }
    }

    @Override
    public boolean isCanonCachesDisabled() {
        return true;
    }

    @Override
    public boolean disableCanonCaches() {
        return true;
    }

    static {
        Class<?> clazz = null;
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        Method method4 = null;
        try {
            clazz = Class.forName("java.util.SequencedCollection");
            Class<?> clazz2 = Class.forName("java.lang.Thread$Builder");
            method = clazz2.getMethod("name", String.class, Long.TYPE);
            method2 = clazz2.getMethod("start", Runnable.class);
            method3 = Thread.class.getMethod("ofVirtual", null);
            method4 = Subject.class.getMethod("callAs", Subject.class, Callable.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug((Object)sm.getString("jre21Compat.javaPre21"), (Throwable)classNotFoundException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            log.error((Object)sm.getString("jre21Compat.unexpected"), (Throwable)reflectiveOperationException);
        }
        supported = clazz != null;
        nameMethod = method;
        startMethod = method2;
        ofVirtualMethod = method3;
        callAsMethod = method4;
    }
}

