/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.plane.AffineTransform;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.List;

public class GlyphShape
extends GraphShape {
    private final char symbol;
    private final Font.Glyph glyph;
    private final int regionVertCount;
    private final int regionIdxCount;
    private final Vec3f origPos;

    public GlyphShape(int n, char c, Font.Glyph glyph, float f, float f2) {
        super(n);
        this.symbol = c;
        this.glyph = glyph;
        this.origPos = new Vec3f(f, f2, 0.0f);
        if (glyph.isWhiteSpace() || null == glyph.getShape()) {
            this.setEnabled(false);
        }
        int[] nArray = Region.countOutlineShape(glyph.getShape(), new int[2]);
        this.regionVertCount = nArray[0];
        this.regionIdxCount = nArray[1];
    }

    public GlyphShape(int n, Font font, char c, float f, float f2) {
        this(n, c, font.getGlyph(font.getGlyphID(c)), f, f2);
    }

    public char getSymbol() {
        return this.symbol;
    }

    public Font.Glyph getGlyph() {
        return this.glyph;
    }

    public Font getFont() {
        return this.glyph.getFont();
    }

    public Vec3f getOrigPos() {
        return this.origPos;
    }

    public Vec3f getOrigPos(Vec3f vec3f) {
        return vec3f.set(this.origPos);
    }

    public Vec3f getOrigPos(float f) {
        return this.origPos.mul(f);
    }

    public Vec3f getOrigPos(Vec3f vec3f, float f) {
        return vec3f.set(this.origPos).scale(f);
    }

    public void resetPos(float f) {
        this.moveTo(this.origPos.x() * f, this.origPos.y() * f, 0.0f);
    }

    public void resetPosAndScale(float f) {
        this.moveTo(this.origPos.x() * f, this.origPos.y() * f, 0.0f);
        this.setScale(f, f, 1.0f);
    }

    public float getLineHeight() {
        return this.glyph.getFont().getLineHeight();
    }

    public static final AABBox processString(final List<GlyphShape> list, final int n, Font font, String string) {
        Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){

            @Override
            public void visit(char c, Font.Glyph glyph, AffineTransform affineTransform) {
                if (!glyph.isWhiteSpace() && null != glyph.getShape()) {
                    list.add(new GlyphShape(n, c, glyph, affineTransform.getTranslateX(), affineTransform.getTranslateY()));
                }
            }
        };
        return font.processString(glyphVisitor, null, string, new AffineTransform(), new AffineTransform());
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        OutlineShape outlineShape = this.glyph.getShape();
        this.box.reset();
        if (null != outlineShape) {
            AABBox aABBox = outlineShape.getBounds();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToTranslation(-aABBox.getMinX(), -aABBox.getMinY() + this.glyph.getBounds().getMinY());
            outlineShape.setSharpness(this.oshapeSharpness);
            this.resetGLRegion(gLProfile, gL2ES2, null, this.regionVertCount, this.regionIdxCount);
            this.region.addOutlineShape(outlineShape, affineTransform, this.rgbaColor);
            this.box.resize(affineTransform.transform(aABBox, new AABBox()));
            this.setRotationPivot(this.box.getCenter());
        }
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", origPos " + this.origPos.x() + " / " + this.origPos.y() + ", '" + this.symbol + "'";
    }
}

