/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class BinaryFloatAccessor
extends Accessor {
    static final int MAXLENGTH = 4;
    private final byte[] tmpBytes;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    BinaryFloatAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.BINARY_FLOAT, stmt, 4, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$16, null, stmt, max_len, form, external_type, forBind);
            }
            this.tmpBytes = new byte[this.representationMaxLength];
            this.init(stmt, 100, 100, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    BinaryFloatAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.BINARY_FLOAT, stmt, 4, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$17, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.tmpBytes = new byte[this.representationMaxLength];
            this.init(stmt, 100, 100, form, false);
            this.initForDescribe(100, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void init(OracleStatement oracleStatement, int n2, int n3, int n4, short s2, int n5) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void max_len;
            void external_type;
            void form;
            void database_type;
            void internal_type;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$0, this, oracleStatement, n2, n3, n4, s2, n5);
            }
            this.init((OracleStatement)stmt, (int)internal_type, (int)database_type, (short)form, false);
            this.initForDataAccess((int)external_type, (int)max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void init(OracleStatement oracleStatement, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, long l2, int n8, short s2) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void total_elems;
            void contflag;
            void scale;
            void precision;
            void flags;
            void nullable;
            int max_len;
            void form;
            void database_type;
            void internal_type;
            void stmt;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$1, this, oracleStatement, n2, n3, n4, bl, n5, n6, n7, l2, n8, s2);
            }
            this.init((OracleStatement)stmt, (int)internal_type, (int)database_type, (short)form, false);
            this.initForDescribe((int)internal_type, max_len, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)total_elems, (short)form, null);
            int max_field_size = stmt.maxFieldSize;
            if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
                max_len = max_field_size;
            }
            this.initForDataAccess(0, max_len, null);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    float getFloat(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                float f2 = 0.0f;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$2, this, Float.valueOf(f2));
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$2, this, null);
                }
                return 0.0f;
            }
            this.rowData.get(this.getOffset((int)currentRow), this.tmpBytes, 0, this.representationMaxLength);
            int b0 = this.tmpBytes[0];
            int b1 = this.tmpBytes[1];
            int b2 = this.tmpBytes[2];
            int b3 = this.tmpBytes[3];
            if ((b0 & 0x80) != 0) {
                b0 &= 0x7F;
                b1 &= 0xFF;
                b2 &= 0xFF;
                b3 &= 0xFF;
            } else {
                b0 = ~b0 & 0xFF;
                b1 = ~b1 & 0xFF;
                b2 = ~b2 & 0xFF;
                b3 = ~b3 & 0xFF;
            }
            int intBits = b0 << 24 | b1 << 16 | b2 << 8 | b3;
            float f3 = Float.intBitsToFloat(intBits);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$2, this, Float.valueOf(f3));
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$2, this, null);
            }
            return f3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$3, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$3, this, string);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            String string = Float.toString(this.getFloat((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$3, this, string);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$3, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$4, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                Object var3_3 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$4, this, var3_3);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$4, this, null);
                }
                return null;
            }
            Float f2 = new Float(this.getFloat((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$4, this, f2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$4, this, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$5, this, n2, map);
            }
            if (this.isNull((int)currentRow)) {
                Object var4_4 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$5, this, var4_4);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            Float f2 = new Float(this.getFloat((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$5, this, f2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$5, this, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$6, this, n2);
            }
            BINARY_FLOAT bINARY_FLOAT = this.getBINARY_FLOAT((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$6, this, bINARY_FLOAT);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$6, this, null);
            }
            return bINARY_FLOAT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    BINARY_FLOAT getBINARY_FLOAT(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$7, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                BINARY_FLOAT bINARY_FLOAT = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$7, this, bINARY_FLOAT);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$7, this, null);
                }
                return null;
            }
            BINARY_FLOAT bINARY_FLOAT = new BINARY_FLOAT(this.rowData.get(this.getOffset((int)currentRow), this.getLength((int)currentRow)));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$7, this, bINARY_FLOAT);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$7, this, null);
            }
            return bINARY_FLOAT;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    NUMBER getNUMBER(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$8, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                NUMBER nUMBER = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$8, this, nUMBER);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$8, this, null);
                }
                return null;
            }
            NUMBER nUMBER = new NUMBER(this.getFloat((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$8, this, nUMBER);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$8, this, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    BigInteger getBigInteger(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$9, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                BigInteger bigInteger = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$9, this, bigInteger);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$9, this, null);
                }
                return null;
            }
            BigInteger bigInteger = this.getBigDecimal((int)currentRow).toBigInteger();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$9, this, bigInteger);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$9, this, null);
            }
            return bigInteger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    BigDecimal getBigDecimal(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                BigDecimal bigDecimal = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$10, this, bigDecimal);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal(this.getString((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$10, this, bigDecimal);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$10, this, null);
            }
            return bigDecimal;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte getByte(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            float f2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$11, this, n2);
            }
            if ((f2 = this.getFloat((int)currentRow)) >= -128.0f && f2 <= 127.0f) {
                byte by = (byte)f2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$11, this, by);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$11, this, null);
                }
                return by;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$11, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    short getShort(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            float f2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$12, this, n2);
            }
            if ((f2 = this.getFloat((int)currentRow)) >= -32768.0f && f2 <= 32767.0f) {
                short s2 = (short)f2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$12, this, s2);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$12, this, null);
                }
                return s2;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$12, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getInt(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            float f2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$13, this, n2);
            }
            if ((f2 = this.getFloat((int)currentRow)) >= -2.1474836E9f && f2 <= 2.1474836E9f) {
                int n3 = (int)f2;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$13, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$13, this, null);
                }
                return n3;
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$13, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    long getLong(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$14, this, n2);
            }
            long l2 = (long)this.getFloat((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$14, this, l2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$14, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    double getDouble(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$15, this, n2);
            }
            double d2 = this.getFloat((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$15, this, d2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$15, this, null);
            }
            return d2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, BinaryFloatAccessor.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$17 = BinaryFloatAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = BinaryFloatAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = BinaryFloatAccessor.class.getDeclaredMethod("getDouble", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = BinaryFloatAccessor.class.getDeclaredMethod("getLong", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = BinaryFloatAccessor.class.getDeclaredMethod("getInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = BinaryFloatAccessor.class.getDeclaredMethod("getShort", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = BinaryFloatAccessor.class.getDeclaredMethod("getByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = BinaryFloatAccessor.class.getDeclaredMethod("getBigDecimal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = BinaryFloatAccessor.class.getDeclaredMethod("getBigInteger", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = BinaryFloatAccessor.class.getDeclaredMethod("getNUMBER", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = BinaryFloatAccessor.class.getDeclaredMethod("getBINARY_FLOAT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = BinaryFloatAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = BinaryFloatAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = BinaryFloatAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = BinaryFloatAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BinaryFloatAccessor.class.getDeclaredMethod("getFloat", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BinaryFloatAccessor.class.getDeclaredMethod("init", OracleStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BinaryFloatAccessor.class.getDeclaredMethod("init", OracleStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

