/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBDoubleField
extends FBField {
    private static final BigDecimal BD_MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal BD_MIN_DOUBLE = new BigDecimal(-1.7976931348623157E308);

    FBDoubleField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDouble();
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        double value = this.getDatatypeCoder().decodeDouble(this.getFieldData());
        if (value > 127.0 || value < -128.0) {
            throw this.invalidGetConversion("byte", String.format("value %f out of range", value));
        }
        return (byte)value;
    }

    @Override
    public short getShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        double value = this.getDatatypeCoder().decodeDouble(this.getFieldData());
        if (value > 32767.0 || value < -32768.0) {
            throw this.invalidGetConversion("short", String.format("value %f out of range", value));
        }
        return (short)value;
    }

    @Override
    public int getInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        double value = this.getDatatypeCoder().decodeDouble(this.getFieldData());
        if (value > 2.147483647E9 || value < -2.147483648E9) {
            throw this.invalidGetConversion("int", String.format("value %f out of range", value));
        }
        return (int)value;
    }

    @Override
    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        double value = this.getDatatypeCoder().decodeDouble(this.getFieldData());
        if (value > 9.223372036854776E18 || value < -9.223372036854776E18) {
            throw this.invalidGetConversion("long", String.format("value %f out of range", value));
        }
        return (long)value;
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        double value = this.getDatatypeCoder().decodeDouble(this.getFieldData());
        float cValue = (float)value;
        if (cValue == Float.POSITIVE_INFINITY || cValue == Float.NEGATIVE_INFINITY) {
            throw this.invalidGetConversion("float", String.format("value %f out of range", value));
        }
        return cValue;
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.getDatatypeCoder().decodeDouble(this.getFieldData());
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.getDatatypeCoder().decodeDouble(this.getFieldData()));
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.getDatatypeCoder().decodeDouble(this.getFieldData()) == 1.0;
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getDatatypeCoder().decodeDouble(this.getFieldData()));
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        String string = value.trim();
        try {
            this.setDouble(Double.parseDouble(string));
        }
        catch (NumberFormatException nfex) {
            SQLException conversionException = this.invalidSetConversion(String.class, string);
            conversionException.initCause(nfex);
            throw conversionException;
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setDouble(value ? 1.0 : 0.0);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setDouble(double value) throws SQLException {
        this.setFieldData(this.getDatatypeCoder().encodeDouble(value));
    }

    @Override
    public void setLong(long value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setDouble(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value.compareTo(BD_MAX_DOUBLE) > 0 || value.compareTo(BD_MIN_DOUBLE) < 0) {
            throw this.invalidSetConversion(BigDecimal.class, String.format("value %f out of range", value));
        }
        this.setDouble(value.doubleValue());
    }
}

