/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.StatementType;
import org.firebirdsql.jaybird.xca.FBLocalTransaction;
import org.firebirdsql.jaybird.xca.FBManagedConnection;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public final class InternalTransactionCoordinator
implements FBObjectListener.StatementListener,
FBObjectListener.BlobListener {
    private final FBConnection connection;
    private AbstractTransactionCoordinator coordinator;

    InternalTransactionCoordinator(FBConnection connection) {
        this.connection = Objects.requireNonNull(connection, "connection");
    }

    private LockCloseable withLock() {
        return this.connection.withLock();
    }

    void switchTransactionCoordinator(boolean autoCommit) throws SQLException {
        if (this.coordinator != null && this.getAutoCommit() == autoCommit) {
            return;
        }
        this.setTransactionCoordinator(false, autoCommit);
    }

    void setTransactionCoordinator(boolean managedConnection, boolean autoCommit) throws SQLException {
        AbstractTransactionCoordinator coordinator;
        FBManagedConnection mc = this.connection.getManagedConnection();
        if (managedConnection && mc.inDistributedTransaction()) {
            coordinator = new ManagedTransactionCoordinator(this.connection);
        } else if (autoCommit) {
            if (mc.inDistributedTransaction()) {
                throw new SQLException("Connection enlisted in distributed transaction", "25000");
            }
            coordinator = this.connection.isUseFirebirdAutoCommit() ? new FirebirdAutoCommitCoordinator(this.connection, this.connection.getLocalTransaction()) : new AutoCommitCoordinator(this.connection, this.connection.getLocalTransaction());
        } else {
            coordinator = new LocalTransactionCoordinator(this.connection, this.connection.getLocalTransaction());
        }
        this.setCoordinator(coordinator);
    }

    public boolean getAutoCommit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            boolean bl = this.coordinator != null && this.coordinator.isAutoCommit();
            return bl;
        }
    }

    @Override
    public void executionStarted(FBStatement stmt) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.coordinator.executionStarted(stmt);
        }
    }

    @Override
    public FBConnection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void statementClosed(FBStatement stmt) throws SQLException {
        this.coordinator.statementClosed(stmt);
    }

    @Override
    public void statementCompleted(FBStatement stmt) throws SQLException {
        this.statementCompleted(stmt, true);
    }

    @Override
    public void statementCompleted(FBStatement stmt, boolean success) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.coordinator.statementCompleted(stmt, success);
        }
    }

    @Override
    public void executionCompleted(FirebirdBlob blob) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.coordinator.executionCompleted(blob);
        }
    }

    @Override
    public void executionStarted(FirebirdBlob blob) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.coordinator.executionStarted(blob);
        }
    }

    public void ensureTransaction() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.coordinator.ensureTransaction();
        }
    }

    public void commit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.coordinator.commit();
        }
    }

    public void rollback() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.coordinator.rollback();
        }
    }

    void handleConnectionClose() throws SQLException {
        this.coordinator.handleConnectionClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCoordinator(AbstractTransactionCoordinator coordinator) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            if (this.coordinator != null) {
                SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
                try {
                    this.coordinator.completeStatements(CompletionReason.COMMIT);
                }
                catch (SQLException ex) {
                    chain.append(ex);
                }
                finally {
                    try {
                        this.coordinator.internalCommit();
                    }
                    catch (SQLException ex) {
                        chain.append(ex);
                    }
                }
                if (chain.hasException()) {
                    throw chain.getException();
                }
                coordinator.setStatements(this.coordinator.getStatements());
            }
            this.coordinator = coordinator;
        }
    }

    static class MetaDataTransactionCoordinator
    extends AbstractTransactionCoordinator {
        private final InternalTransactionCoordinator tc;

        public MetaDataTransactionCoordinator(InternalTransactionCoordinator tc) {
            super(tc.connection, tc.connection.getLocalTransaction());
            this.tc = tc;
        }

        @Override
        public void ensureTransaction() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void commit() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rollback() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        void handleConnectionClose() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void executionStarted(FBStatement stmt) throws SQLException {
            this.tc.ensureTransaction();
        }

        @Override
        public void statementClosed(FBStatement stmt) throws SQLException {
            stmt.completeStatement();
        }

        @Override
        public void statementCompleted(FBStatement stmt, boolean success) throws SQLException {
        }

        @Override
        public void executionCompleted(FirebirdBlob blob) throws SQLException {
        }

        @Override
        public void executionStarted(FirebirdBlob blob) throws SQLException {
        }

        @Override
        boolean isAutoCommit() throws SQLException {
            return this.tc.getAutoCommit();
        }
    }

    static class ManagedTransactionCoordinator
    extends LocalTransactionCoordinator {
        public ManagedTransactionCoordinator(FBConnection connection) {
            super(connection, null);
        }

        @Override
        public void ensureTransaction() throws SQLException {
        }

        @Override
        public void executionStarted(FBStatement stmt) throws SQLException {
        }

        @Override
        public void commit() throws SQLException {
        }

        @Override
        public void rollback() throws SQLException {
        }

        @Override
        public void executionStarted(FirebirdBlob blob) throws SQLException {
        }

        @Override
        void handleConnectionClose() throws SQLException {
        }
    }

    static class FirebirdAutoCommitCoordinator
    extends LocalTransactionCoordinator {
        public FirebirdAutoCommitCoordinator(FBConnection connection, FBLocalTransaction localTransaction) {
            super(connection, localTransaction);
        }

        @Override
        public void executionStarted(FBStatement stmt) throws SQLException {
            ArrayList tempList = new ArrayList(this.statements);
            SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
            Iterator iter = tempList.iterator();
            while (iter.hasNext()) {
                FBStatement tempStatement = (FBStatement)iter.next();
                if (tempStatement == stmt) {
                    iter.remove();
                    continue;
                }
                try {
                    tempStatement.completeStatement(CompletionReason.COMMIT);
                }
                catch (SQLException e) {
                    chain.append(e);
                }
            }
            this.statements.removeAll(tempList);
            if (chain.hasException()) {
                throw chain.getException();
            }
            if (!this.statements.contains(stmt)) {
                this.statements.add(stmt);
            }
            this.ensureTransaction();
        }

        @Override
        public void statementCompleted(FBStatement stmt, boolean success) throws SQLException {
            this.statements.remove(stmt);
            if (stmt.getStatementType() == StatementType.DDL.getStatementTypeCode()) {
                try {
                    if (!this.localTransaction.inTransaction()) {
                        return;
                    }
                    if (success) {
                        this.localTransaction.commit();
                    } else {
                        this.localTransaction.rollback();
                    }
                }
                catch (SQLException ex) {
                    try {
                        this.internalRollback();
                    }
                    catch (SQLException ex2) {
                        ex.setNextException(ex2);
                    }
                    throw ex;
                }
            }
        }

        @Override
        public void commit() throws SQLException {
            throw new FBSQLException("Calling commit() in auto-commit mode is not allowed.");
        }

        @Override
        public void rollback() throws SQLException {
            throw new FBSQLException("Calling rollback() in auto-commit mode is not allowed.");
        }

        @Override
        void handleConnectionClose() throws SQLException {
            if (this.localTransaction.inTransaction()) {
                try {
                    this.completeStatements(CompletionReason.COMMIT);
                }
                finally {
                    this.internalCommit();
                }
            }
        }

        @Override
        boolean isAutoCommit() {
            return true;
        }
    }

    static class LocalTransactionCoordinator
    extends AbstractTransactionCoordinator {
        public LocalTransactionCoordinator(FBConnection connection, FBLocalTransaction localTransaction) {
            super(connection, localTransaction);
        }

        @Override
        public void commit() throws SQLException {
            try {
                this.completeStatements(CompletionReason.COMMIT);
            }
            finally {
                this.internalCommit();
            }
        }

        @Override
        public void rollback() throws SQLException {
            try {
                this.completeStatements(CompletionReason.ROLLBACK);
            }
            finally {
                this.internalRollback();
            }
        }

        @Override
        void handleConnectionClose() throws SQLException {
            if (this.localTransaction.inTransaction()) {
                this.rollback();
            }
        }

        @Override
        public void executionStarted(FBStatement stmt) throws SQLException {
            if (!this.statements.contains(stmt)) {
                this.statements.add(stmt);
            }
            this.ensureTransaction();
        }

        @Override
        public void statementClosed(FBStatement stmt) throws SQLException {
            stmt.completeStatement();
            this.connection.notifyStatementClosed(stmt);
        }

        @Override
        public void statementCompleted(FBStatement stmt, boolean success) throws SQLException {
            this.statements.remove(stmt);
        }

        @Override
        public void executionCompleted(FirebirdBlob blob) throws SQLException {
        }

        @Override
        public void executionStarted(FirebirdBlob blob) throws SQLException {
            this.ensureTransaction();
        }
    }

    static class AutoCommitCoordinator
    extends AbstractTransactionCoordinator {
        public AutoCommitCoordinator(FBConnection connection, FBLocalTransaction localTransaction) {
            super(connection, localTransaction);
        }

        @Override
        public void executionStarted(FBStatement stmt) throws SQLException {
            ArrayList tempList = new ArrayList(this.statements);
            SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
            Iterator iter = tempList.iterator();
            while (iter.hasNext()) {
                FBStatement tempStatement = (FBStatement)iter.next();
                if (tempStatement == stmt) {
                    iter.remove();
                    continue;
                }
                try {
                    tempStatement.completeStatement(CompletionReason.COMMIT);
                }
                catch (SQLException e) {
                    chain.append(e);
                }
            }
            this.statements.removeAll(tempList);
            if (chain.hasException()) {
                throw chain.getException();
            }
            if (!this.statements.contains(stmt)) {
                this.statements.add(stmt);
            }
            this.ensureTransaction();
        }

        @Override
        public void statementClosed(FBStatement stmt) throws SQLException {
            stmt.completeStatement();
            this.connection.notifyStatementClosed(stmt);
        }

        @Override
        public void statementCompleted(FBStatement stmt, boolean success) throws SQLException {
            this.statements.remove(stmt);
            try {
                if (!this.localTransaction.inTransaction()) {
                    return;
                }
                if (success) {
                    this.localTransaction.commit();
                } else {
                    this.localTransaction.rollback();
                }
            }
            catch (SQLException ex) {
                try {
                    this.internalRollback();
                }
                catch (SQLException ex2) {
                    ex.setNextException(ex2);
                }
                throw ex;
            }
        }

        @Override
        public void executionCompleted(FirebirdBlob blob) throws SQLException {
        }

        @Override
        public void executionStarted(FirebirdBlob blob) throws SQLException {
            this.ensureTransaction();
        }

        @Override
        public void commit() throws SQLException {
            throw new FBSQLException("Calling commit() in auto-commit mode is not allowed.");
        }

        @Override
        public void rollback() throws SQLException {
            throw new FBSQLException("Calling rollback() in auto-commit mode is not allowed.");
        }

        @Override
        void handleConnectionClose() throws SQLException {
            if (this.localTransaction.inTransaction()) {
                try {
                    this.completeStatements(CompletionReason.COMMIT);
                }
                finally {
                    this.internalCommit();
                }
            }
        }

        @Override
        boolean isAutoCommit() {
            return true;
        }
    }

    public static abstract class AbstractTransactionCoordinator
    implements FBObjectListener.StatementListener,
    FBObjectListener.BlobListener {
        protected final FBLocalTransaction localTransaction;
        protected final FBConnection connection;
        protected final Collection<FBStatement> statements = new HashSet<FBStatement>();

        protected AbstractTransactionCoordinator(FBConnection connection, FBLocalTransaction localTransaction) {
            this.localTransaction = localTransaction;
            this.connection = connection;
        }

        @Override
        public final FBConnection getConnection() throws SQLException {
            return this.connection;
        }

        protected final Collection<FBStatement> getStatements() {
            return this.statements;
        }

        protected final void setStatements(Collection<FBStatement> statements) {
            this.statements.addAll(statements);
        }

        protected void completeStatements(CompletionReason reason) throws SQLException {
            FBStatement[] statementsToComplete;
            SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
            for (FBStatement statement : statementsToComplete = this.statements.toArray(new FBStatement[0])) {
                try {
                    statement.completeStatement(reason);
                }
                catch (SQLException ex) {
                    chain.append(ex);
                }
            }
            this.statements.clear();
            if (chain.hasException()) {
                throw chain.getException();
            }
        }

        final void internalCommit() throws SQLException {
            if (this.localTransaction != null && this.localTransaction.inTransaction()) {
                this.localTransaction.commit();
            }
        }

        final void internalRollback() throws SQLException {
            if (this.localTransaction != null && this.localTransaction.inTransaction()) {
                this.localTransaction.rollback();
            }
        }

        public void ensureTransaction() throws SQLException {
            this.configureFirebirdAutoCommit();
            if (!this.localTransaction.inTransaction()) {
                this.localTransaction.begin();
            }
        }

        private void configureFirebirdAutoCommit() throws SQLException {
            if (this.connection.isUseFirebirdAutoCommit()) {
                TransactionParameterBuffer tpb = this.connection.getManagedConnection().getTransactionParameters();
                if (this.connection.getAutoCommit()) {
                    if (!tpb.hasArgument(16)) {
                        tpb.addArgument(16);
                    }
                } else {
                    tpb.removeArgument(16);
                }
            }
        }

        public abstract void commit() throws SQLException;

        public abstract void rollback() throws SQLException;

        abstract void handleConnectionClose() throws SQLException;

        boolean isAutoCommit() throws SQLException {
            return false;
        }

        @Override
        public final void statementCompleted(FBStatement stmt) throws SQLException {
            this.statementCompleted(stmt, true);
        }
    }
}

