# This file has been autogenerated by the pywayland scanner

# Copyright © 2014, 2015 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..wayland import WlSurface
from .zwp_linux_buffer_params_v1 import ZwpLinuxBufferParamsV1
from .zwp_linux_dmabuf_feedback_v1 import ZwpLinuxDmabufFeedbackV1


class ZwpLinuxDmabufV1(Interface):
    """Factory for creating dmabuf-based wl_buffers

    Following the interfaces from:
    https://www.khronos.org/registry/egl/extensions/EXT/EGL_EXT_image_dma_buf_import.txt
    https://www.khronos.org/registry/EGL/extensions/EXT/EGL_EXT_image_dma_buf_import_modifiers.txt
    and the Linux DRM sub-system's AddFb2 ioctl.

    This interface offers ways to create generic dmabuf-based wl_buffers.

    Clients can use the get_surface_feedback request to get dmabuf feedback for
    a particular surface. If the client wants to retrieve feedback not tied to
    a surface, they can use the get_default_feedback request.

    The following are required from clients:

    - Clients must ensure that either all data in the dma-buf is coherent for
      all subsequent read access or that coherency is correctly handled by the
      underlying kernel-side dma-buf implementation.

    - Don't make any more attachments after sending the buffer to the
      compositor. Making more attachments later increases the risk of the
      compositor not being able to use (re-import) an existing dmabuf-based
      :class:`~pywayland.protocol.wayland.WlBuffer`.

    The underlying graphics stack must ensure the following:

    - The dmabuf file descriptors relayed to the server will stay valid for the
      whole lifetime of the :class:`~pywayland.protocol.wayland.WlBuffer`. This
      means the server may at any time use those fds to import the dmabuf into
      any kernel sub-system that might accept it.

    However, when the underlying graphics stack fails to deliver the promise,
    because of e.g. a device hot-unplug which raises internal errors, after the
    :class:`~pywayland.protocol.wayland.WlBuffer` has been successfully created
    the compositor must not raise protocol errors to the client when dmabuf
    import later fails.

    To create a :class:`~pywayland.protocol.wayland.WlBuffer` from one or more
    dmabufs, a client creates a zwp_linux_dmabuf_params_v1 object with a
    :func:`ZwpLinuxDmabufV1.create_params()` request. All planes required by
    the intended format are added with the 'add' request. Finally, a 'create'
    or 'create_immed' request is issued, which has the following outcome
    depending on the import success.

    The 'create' request, - on success, triggers a 'created' event which
    provides the final   :class:`~pywayland.protocol.wayland.WlBuffer` to the
    client. - on failure, triggers a 'failed' event to convey that the server
    cannot use the dmabufs received from the client.

    For the 'create_immed' request, - on success, the server immediately
    imports the added dmabufs to   create a
    :class:`~pywayland.protocol.wayland.WlBuffer`. No event is sent from the
    server in this case. - on failure, the server can choose to either:   -
    terminate the client by raising a fatal error.   - mark the
    :class:`~pywayland.protocol.wayland.WlBuffer` as failed, and send a
    'failed' event to the     client. If the client uses a failed
    :class:`~pywayland.protocol.wayland.WlBuffer` as an argument to any
    request, the behaviour is compositor implementation-defined.

    For all DRM formats and unless specified in another protocol extension,
    pre-multiplied alpha is used for pixel values.

    Warning! The protocol described in this file is experimental and backward
    incompatible changes may be made. Backward compatible changes may be added
    together with the corresponding interface version bump. Backward
    incompatible changes are done by bumping the version number in the protocol
    and interface names and resetting the interface version. Once the protocol
    is to be declared stable, the 'z' prefix and the version number in the
    protocol and interface names are removed and the interface version number
    is reset.
    """

    name = "zwp_linux_dmabuf_v1"
    version = 4


class ZwpLinuxDmabufV1Proxy(Proxy[ZwpLinuxDmabufV1]):
    interface = ZwpLinuxDmabufV1

    @ZwpLinuxDmabufV1.request()
    def destroy(self) -> None:
        """Unbind the factory

        Objects created through this interface, especially wl_buffers, will
        remain valid.
        """
        self._marshal(0)
        self._destroy()

    @ZwpLinuxDmabufV1.request(
        Argument(ArgumentType.NewId, interface=ZwpLinuxBufferParamsV1),
    )
    def create_params(self) -> Proxy[ZwpLinuxBufferParamsV1]:
        """Create a temporary object for buffer parameters

        This temporary object is used to collect multiple dmabuf handles into a
        single batch to create a :class:`~pywayland.protocol.wayland.WlBuffer`.
        It can only be used once and should be destroyed after a 'created' or
        'failed' event has been received.

        :returns:
            :class:`~pywayland.protocol.linux_dmabuf_unstable_v1.ZwpLinuxBufferParamsV1`
            -- the new temporary
        """
        params_id = self._marshal_constructor(1, ZwpLinuxBufferParamsV1)
        return params_id

    @ZwpLinuxDmabufV1.request(
        Argument(ArgumentType.NewId, interface=ZwpLinuxDmabufFeedbackV1),
        version=4,
    )
    def get_default_feedback(self) -> Proxy[ZwpLinuxDmabufFeedbackV1]:
        """Get default feedback

        This request creates a new wp_linux_dmabuf_feedback object not bound to
        a particular surface. This object will deliver feedback about dmabuf
        parameters to use if the client doesn't support per-surface feedback
        (see get_surface_feedback).

        :returns:
            :class:`~pywayland.protocol.linux_dmabuf_unstable_v1.ZwpLinuxDmabufFeedbackV1`
        """
        id = self._marshal_constructor(2, ZwpLinuxDmabufFeedbackV1)
        return id

    @ZwpLinuxDmabufV1.request(
        Argument(ArgumentType.NewId, interface=ZwpLinuxDmabufFeedbackV1),
        Argument(ArgumentType.Object, interface=WlSurface),
        version=4,
    )
    def get_surface_feedback(self, surface: WlSurface) -> Proxy[ZwpLinuxDmabufFeedbackV1]:
        """Get feedback for a surface

        This request creates a new wp_linux_dmabuf_feedback object for the
        specified :class:`~pywayland.protocol.wayland.WlSurface`. This object
        will deliver feedback about dmabuf parameters to use for buffers
        attached to this surface.

        If the surface is destroyed before the wp_linux_dmabuf_feedback object,
        the feedback object becomes inert.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.linux_dmabuf_unstable_v1.ZwpLinuxDmabufFeedbackV1`
        """
        id = self._marshal_constructor(3, ZwpLinuxDmabufFeedbackV1, surface)
        return id


class ZwpLinuxDmabufV1Resource(Resource):
    interface = ZwpLinuxDmabufV1

    @ZwpLinuxDmabufV1.event(
        Argument(ArgumentType.Uint),
    )
    def format(self, format: int) -> None:
        """Supported buffer format

        This event advertises one buffer format that the server supports. All
        the supported formats are advertised once when the client binds to this
        interface. A roundtrip after binding guarantees that the client has
        received all supported formats.

        For the definition of the format codes, see the
        :class:`~pywayland.protocol.linux_dmabuf_unstable_v1.ZwpLinuxBufferParamsV1`::create
        request.

        Starting version 4, the format event is deprecated and must not be sent
        by compositors. Instead, use get_default_feedback or
        get_surface_feedback.

        :param format:
            DRM_FORMAT code
        :type format:
            `ArgumentType.Uint`
        """
        self._post_event(0, format)

    @ZwpLinuxDmabufV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        version=3,
    )
    def modifier(self, format: int, modifier_hi: int, modifier_lo: int) -> None:
        """Supported buffer format modifier

        This event advertises the formats that the server supports, along with
        the modifiers supported for each format. All the supported modifiers
        for all the supported formats are advertised once when the client binds
        to this interface. A roundtrip after binding guarantees that the client
        has received all supported format-modifier pairs.

        For legacy support, DRM_FORMAT_MOD_INVALID (that is, modifier_hi ==
        0x00ffffff and modifier_lo == 0xffffffff) is allowed in this event. It
        indicates that the server can support the format with an implicit
        modifier. When a plane has DRM_FORMAT_MOD_INVALID as its modifier, it
        is as if no explicit modifier is specified. The effective modifier will
        be derived from the dmabuf.

        A compositor that sends valid modifiers and DRM_FORMAT_MOD_INVALID for
        a given format supports both explicit modifiers and implicit modifiers.

        For the definition of the format and modifier codes, see the
        :class:`~pywayland.protocol.linux_dmabuf_unstable_v1.ZwpLinuxBufferParamsV1`::create
        and
        :class:`~pywayland.protocol.linux_dmabuf_unstable_v1.ZwpLinuxBufferParamsV1`::add
        requests.

        Starting version 4, the modifier event is deprecated and must not be
        sent by compositors. Instead, use get_default_feedback or
        get_surface_feedback.

        :param format:
            DRM_FORMAT code
        :type format:
            `ArgumentType.Uint`
        :param modifier_hi:
            high 32 bits of layout modifier
        :type modifier_hi:
            `ArgumentType.Uint`
        :param modifier_lo:
            low 32 bits of layout modifier
        :type modifier_lo:
            `ArgumentType.Uint`
        """
        self._post_event(1, format, modifier_hi, modifier_lo)


class ZwpLinuxDmabufV1Global(Global):
    interface = ZwpLinuxDmabufV1


ZwpLinuxDmabufV1._gen_c()
ZwpLinuxDmabufV1.proxy_class = ZwpLinuxDmabufV1Proxy
ZwpLinuxDmabufV1.resource_class = ZwpLinuxDmabufV1Resource
ZwpLinuxDmabufV1.global_class = ZwpLinuxDmabufV1Global
