/// <reference types="react" />
import { Panel } from "./panelTypes";
export interface PanelView2Props<T extends Panel<object>> {
    /**
     * Callback invoked when the user presses the back button or a panel invokes
     * the `closePanel()` injected prop method.
     */
    onClose: (removedPanel: T) => void;
    /**
     * Callback invoked when a panel invokes the `openPanel(panel)` injected
     * prop method.
     */
    onOpen: (addedPanel: T) => void;
    /** The panel to be displayed. */
    panel: T;
    /** The previous panel in the stack, for rendering the "back" button. */
    previousPanel?: T;
    /** Whether to show the header with the "back" button. */
    showHeader: boolean;
}
interface PanelView2Component {
    <T extends Panel<object>>(props: PanelView2Props<T>): JSX.Element | null;
    displayName: string;
}
export declare const PanelView2: PanelView2Component;
export {};
