"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsBuilder = void 0;

var _lodash = require("lodash");

var _aggragations = require("../tree/aggragations");

var _expression = require("../expression");

var _explorer = require("../../../../common/constants/explorer");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class StatsBuilder {
  constructor(statsChunk) {
    this.statsChunk = statsChunk;
  }

  build() {
    // return a new stats subtree
    return new _aggragations.Aggregations('stats_command', [], !(0, _lodash.isEmpty)(this.statsChunk.partitions) ? this.buildParttions(this.statsChunk.partitions) : '', !(0, _lodash.isEmpty)(this.statsChunk.all_num) ? this.buildAllNum(this.statsChunk.all_num) : '', !(0, _lodash.isEmpty)(this.statsChunk.delim) ? this.buildDelim(this.statsChunk.delim) : '', !(0, _lodash.isEmpty)(this.statsChunk.aggregations) ? this.buildAggList(this.statsChunk.aggregations) : [], !(0, _lodash.isEmpty)(this.statsChunk.groupby) ? this.buildGroupList(this.statsChunk.groupby) : new _expression.GroupBy('stats_by_clause', [], [], null), !(0, _lodash.isEmpty)(this.statsChunk.dedup_split_value) ? this.buildDedupSplitValue(this.statsChunk.dedup_split_value) : '');
  }
  /**
   * Flags
   */


  buildParttions(partitions) {
    return `${partitions.keyword} ${partitions.sign} ${partitions.value}`;
  }

  buildAllNum(allNum) {
    return `${allNum.keyword} ${allNum.sign} ${allNum.value}`;
  }

  buildDelim(delim) {
    return `${delim.keyword} ${delim.sign} ${delim.value}`;
  }

  buildDedupSplitValue(dedupSplitvalue) {
    return `${dedupSplitvalue.keyword} ${dedupSplitvalue.sign} ${dedupSplitvalue.value}`;
  }
  /**
   * Aggregations
   */


  buildAggList(aggregations) {
    return aggregations.map(aggregation => {
      return this.buildAggTerm(aggregation);
    });
  }

  buildAggTerm(aggTerm) {
    return new _expression.AggregateTerm('stats_agg_term', [], this.buildAggregateFunction(aggTerm.function), aggTerm.function_alias);
  }

  buildAggregateFunction(aggFunction) {
    return new _expression.AggregateFunction('stats_function', [], aggFunction.name, aggFunction.value_expression, aggFunction.percentile_agg_function);
  }
  /**
   * Groups
   */


  buildGroupList(groupby) {
    return new _expression.GroupBy('stats_by_clause', [], this.buildFieldList(groupby.group_fields), groupby.span ? this.buildSpan(groupby.span) : null);
  }

  buildFieldList(group_fields) {
    return group_fields.map(gf => {
      return new _expression.Field('field_expression', [], gf.name);
    });
  }

  buildSpan(span) {
    return new _expression.Span('span_clause', [], this.buildeSpanExpression(span.span_expression), span[_explorer.CUSTOM_LABEL]);
  }

  buildeSpanExpression(spanExpression) {
    return new _expression.SpanExpression('span_expression', [], spanExpression.field, spanExpression.literal_value, spanExpression.time_unit);
  }

}

exports.StatsBuilder = StatsBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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