/**
 * Represents an HTTP error from the Matrix server.
 * @category Error handling
 */
export declare class MatrixError extends Error {
    readonly body: {
        errcode: string;
        error: string;
        retry_after_ms?: number;
    };
    readonly statusCode: number;
    /**
     * The Matrix error code
     */
    readonly errcode: string;
    /**
     * Optional human-readable error message.
     */
    readonly error: string;
    /**
     * If rate limited, the time in milliseconds to wait before retrying the request
     */
    readonly retryAfterMs?: number;
    /**
     * Creates a new Matrix Error
     * @param body The error body.
     * @param statusCode The HTTP status code.
     */
    constructor(body: {
        errcode: string;
        error: string;
        retry_after_ms?: number;
    }, statusCode: number);
    /**
     * Developer-friendly error message.
     */
    get message(): string;
}
