Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var utils_1 = require("@sentry/utils");
var flags_1 = require("../flags");
// "Script error." is hard coded into browsers for errors that it can't read.
// this is the result of a script being pulled in from an external domain and CORS.
var DEFAULT_IGNORE_ERRORS = [/^Script error\.?$/, /^Javascript error: Script error\.? on line 0$/];
/** Inbound filters configurable by the user */
var InboundFilters = /** @class */ (function () {
    function InboundFilters(_options) {
        if (_options === void 0) { _options = {}; }
        this._options = _options;
        /**
         * @inheritDoc
         */
        this.name = InboundFilters.id;
    }
    /**
     * @inheritDoc
     */
    InboundFilters.prototype.setupOnce = function (addGlobalEventProcessor, getCurrentHub) {
        addGlobalEventProcessor(function (event) {
            var hub = getCurrentHub();
            if (hub) {
                var self_1 = hub.getIntegration(InboundFilters);
                if (self_1) {
                    var client = hub.getClient();
                    var clientOptions = client ? client.getOptions() : {};
                    var options = _mergeOptions(self_1._options, clientOptions);
                    return _shouldDropEvent(event, options) ? null : event;
                }
            }
            return event;
        });
    };
    /**
     * @inheritDoc
     */
    InboundFilters.id = 'InboundFilters';
    return InboundFilters;
}());
exports.InboundFilters = InboundFilters;
/** JSDoc */
function _mergeOptions(internalOptions, clientOptions) {
    if (internalOptions === void 0) { internalOptions = {}; }
    if (clientOptions === void 0) { clientOptions = {}; }
    return {
        allowUrls: tslib_1.__spread((internalOptions.whitelistUrls || []), (internalOptions.allowUrls || []), (clientOptions.whitelistUrls || []), (clientOptions.allowUrls || [])),
        denyUrls: tslib_1.__spread((internalOptions.blacklistUrls || []), (internalOptions.denyUrls || []), (clientOptions.blacklistUrls || []), (clientOptions.denyUrls || [])),
        ignoreErrors: tslib_1.__spread((internalOptions.ignoreErrors || []), (clientOptions.ignoreErrors || []), DEFAULT_IGNORE_ERRORS),
        ignoreInternal: internalOptions.ignoreInternal !== undefined ? internalOptions.ignoreInternal : true,
    };
}
exports._mergeOptions = _mergeOptions;
/** JSDoc */
function _shouldDropEvent(event, options) {
    if (options.ignoreInternal && _isSentryError(event)) {
        flags_1.IS_DEBUG_BUILD &&
            utils_1.logger.warn("Event dropped due to being internal Sentry Error.\nEvent: " + utils_1.getEventDescription(event));
        return true;
    }
    if (_isIgnoredError(event, options.ignoreErrors)) {
        flags_1.IS_DEBUG_BUILD &&
            utils_1.logger.warn("Event dropped due to being matched by `ignoreErrors` option.\nEvent: " + utils_1.getEventDescription(event));
        return true;
    }
    if (_isDeniedUrl(event, options.denyUrls)) {
        flags_1.IS_DEBUG_BUILD &&
            utils_1.logger.warn("Event dropped due to being matched by `denyUrls` option.\nEvent: " + utils_1.getEventDescription(event) + ".\nUrl: " + _getEventFilterUrl(event));
        return true;
    }
    if (!_isAllowedUrl(event, options.allowUrls)) {
        flags_1.IS_DEBUG_BUILD &&
            utils_1.logger.warn("Event dropped due to not being matched by `allowUrls` option.\nEvent: " + utils_1.getEventDescription(event) + ".\nUrl: " + _getEventFilterUrl(event));
        return true;
    }
    return false;
}
exports._shouldDropEvent = _shouldDropEvent;
function _isIgnoredError(event, ignoreErrors) {
    if (!ignoreErrors || !ignoreErrors.length) {
        return false;
    }
    return _getPossibleEventMessages(event).some(function (message) {
        return ignoreErrors.some(function (pattern) { return utils_1.isMatchingPattern(message, pattern); });
    });
}
function _isDeniedUrl(event, denyUrls) {
    // TODO: Use Glob instead?
    if (!denyUrls || !denyUrls.length) {
        return false;
    }
    var url = _getEventFilterUrl(event);
    return !url ? false : denyUrls.some(function (pattern) { return utils_1.isMatchingPattern(url, pattern); });
}
function _isAllowedUrl(event, allowUrls) {
    // TODO: Use Glob instead?
    if (!allowUrls || !allowUrls.length) {
        return true;
    }
    var url = _getEventFilterUrl(event);
    return !url ? true : allowUrls.some(function (pattern) { return utils_1.isMatchingPattern(url, pattern); });
}
function _getPossibleEventMessages(event) {
    if (event.message) {
        return [event.message];
    }
    if (event.exception) {
        try {
            var _a = (event.exception.values && event.exception.values[0]) || {}, _b = _a.type, type = _b === void 0 ? '' : _b, _c = _a.value, value = _c === void 0 ? '' : _c;
            return ["" + value, type + ": " + value];
        }
        catch (oO) {
            flags_1.IS_DEBUG_BUILD && utils_1.logger.error("Cannot extract message for event " + utils_1.getEventDescription(event));
            return [];
        }
    }
    return [];
}
function _isSentryError(event) {
    try {
        // @ts-ignore can't be a sentry error if undefined
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        return event.exception.values[0].type === 'SentryError';
    }
    catch (e) {
        // ignore
    }
    return false;
}
function _getLastValidUrl(frames) {
    if (frames === void 0) { frames = []; }
    for (var i = frames.length - 1; i >= 0; i--) {
        var frame = frames[i];
        if (frame && frame.filename !== '<anonymous>' && frame.filename !== '[native code]') {
            return frame.filename || null;
        }
    }
    return null;
}
function _getEventFilterUrl(event) {
    try {
        if (event.stacktrace) {
            return _getLastValidUrl(event.stacktrace.frames);
        }
        var frames_1;
        try {
            // @ts-ignore we only care about frames if the whole thing here is defined
            frames_1 = event.exception.values[0].stacktrace.frames;
        }
        catch (e) {
            // ignore
        }
        return frames_1 ? _getLastValidUrl(frames_1) : null;
    }
    catch (oO) {
        flags_1.IS_DEBUG_BUILD && utils_1.logger.error("Cannot extract url for event " + utils_1.getEventDescription(event));
        return null;
    }
}
//# sourceMappingURL=inboundfilters.js.map