/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openoffice.xmerge.converter.xml.EmbeddedObject;
import org.openoffice.xmerge.converter.xml.OfficeDocument;
import org.openoffice.xmerge.converter.xml.OfficeZip;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class EmbeddedXMLObject
extends EmbeddedObject {
    private Document contentDOM = null;
    private Document settingsDOM = null;
    private Document stylesDOM = null;
    private DocumentBuilder builder = null;

    public EmbeddedXMLObject(String string, String string2) {
        super(string, string2);
    }

    EmbeddedXMLObject(String string, String string2, OfficeZip officeZip) {
        super(string, string2, officeZip);
    }

    public Document getContentDOM() throws SAXException, IOException {
        if (this.contentDOM == null) {
            this.contentDOM = this.getNamedDOM("content.xml");
        }
        return this.contentDOM;
    }

    public void setContentDOM(Document document) {
        this.contentDOM = document;
        this.hasChanged = true;
    }

    public Document getSettingsDOM() throws SAXException, IOException {
        if (this.settingsDOM == null) {
            this.settingsDOM = this.getNamedDOM("settings.xml");
        }
        return this.settingsDOM;
    }

    public void setSettingsDOM(Document document) {
        this.settingsDOM = document;
        this.hasChanged = true;
    }

    public Document getStylesDOM() throws SAXException, IOException {
        if (this.stylesDOM == null) {
            this.stylesDOM = this.getNamedDOM("styles.xml");
        }
        return this.stylesDOM;
    }

    public void setStylesDOM(Document document) {
        this.stylesDOM = document;
        this.hasChanged = true;
    }

    private Document getNamedDOM(String string) throws SAXException, IOException {
        if (this.zipFile == null) {
            return null;
        }
        try {
            Object object;
            if (this.builder == null) {
                object = DocumentBuilderFactory.newInstance();
                ((DocumentBuilderFactory)object).setValidating(false);
                this.builder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            }
            if ((object = (Object)this.zipFile.getNamedBytes(this.objName + "/" + string)) != null) {
                return OfficeDocument.parse(this.builder, (byte[])object);
            }
            return null;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    @Override
    void write(OfficeZip officeZip) throws IOException {
        if (this.hasChanged) {
            if (this.contentDOM != null) {
                officeZip.setNamedBytes(this.objName + "/content.xml", OfficeDocument.docToBytes(this.contentDOM));
            }
            if (this.settingsDOM != null) {
                officeZip.setNamedBytes(this.objName + "/settings.xml", OfficeDocument.docToBytes(this.settingsDOM));
            }
            if (this.stylesDOM != null) {
                officeZip.setNamedBytes(this.objName + "/styles.xml", OfficeDocument.docToBytes(this.stylesDOM));
            }
        }
    }

    @Override
    void writeManifestData(Document document) throws DOMException {
        Element element;
        Element element2 = document.getDocumentElement();
        if (this.contentDOM != null) {
            element = document.createElement("manifest:file-entry");
            element.setAttribute("manifest:media-type", "text/xml");
            element.setAttribute("manifest:full-path", this.objName + "/content.xml");
            element2.appendChild(element);
        }
        if (this.settingsDOM != null) {
            element = document.createElement("manifest:file-entry");
            element.setAttribute("manifest:media-type", "text/xml");
            element.setAttribute("manifest:full-path", this.objName + "/settings.xml");
            element2.appendChild(element);
        }
        if (this.stylesDOM != null) {
            element = document.createElement("manifest:file-entry");
            element.setAttribute("manifest:media-type", "text/xml");
            element.setAttribute("manifest:full-path", this.objName + "/styles.xml");
        }
        element = document.createElement("manifest:file-entry");
        element.setAttribute("manifest:media-type", this.objType);
        element.setAttribute("manifest:full-path", this.objName + "/");
        element2.appendChild(element);
    }
}

