/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSocketDirect;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSocketUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvSSLServerSocket
extends SSLServerSocket {
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = false;

    protected ProvSSLServerSocket(ContextData contextData) throws IOException {
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
    }

    protected ProvSSLServerSocket(ContextData contextData, int n) throws IOException {
        super(n);
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
    }

    protected ProvSSLServerSocket(ContextData contextData, int n, int n2) throws IOException {
        super(n, n2);
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
    }

    protected ProvSSLServerSocket(ContextData contextData, int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        this.contextData = contextData;
        this.sslParameters = contextData.getContext().getDefaultSSLParameters(this.useClientMode);
    }

    @Override
    public synchronized Socket accept() throws IOException {
        ProvSSLSocketDirect provSSLSocketDirect = SSLSocketUtil.create(this.contextData, this.enableSessionCreation, this.useClientMode, this.sslParameters.copy());
        this.implAccept(provSSLSocketDirect);
        provSSLSocketDirect.notifyConnected();
        return provSSLSocketDirect;
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.contextData.getContext().getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.contextData.getContext().getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.sslParameters.setCipherSuites(stringArray);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        this.sslParameters.setProtocols(stringArray);
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sSLParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        if (this.useClientMode != bl) {
            this.contextData.getContext().updateDefaultSSLParameters(this.sslParameters, bl);
            this.useClientMode = bl;
        }
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }
}

