/**
 * Wrap a fragment in a document.
 *
 * @param {Readonly<Options> | null | undefined} [options]
 *   Configuration (optional).
 * @returns
 *   Transform.
 */
export default function rehypeDocument(options?: Readonly<Options> | null | undefined): (tree: Root, file: VFile) => Root;
export type ElementContent = import('hast').ElementContent;
export type Nodes = import('hast').Nodes;
export type Root = import('hast').Root;
export type Properties = import('hastscript').Properties;
export type VFile = import('vfile').VFile;
/**
 * Configuration.
 */
export type Options = {
    /**
     * URLs to stylesheets to use in `<link>`s (optional).
     */
    css?: Array<string> | string | null | undefined;
    /**
     * Direction of the document (optional).
     */
    dir?: 'auto' | 'ltr' | 'rtl' | null | undefined;
    /**
     * URLs to scripts to use as `src` on `<script>`s (optional).
     */
    js?: Array<string> | string | null | undefined;
    /**
     * Language of document (default: `'en'`); should be a
     * [BCP 47](https://tools.ietf.org/html/bcp47) language tag.
     */
    language?: string | null | undefined;
    /**
     * Generate extra `<link>`s with these properties (optional); passed as
     * `properties` to [`hastscript`](https://github.com/syntax-tree/hastscript)
     * with `'link'`.
     */
    link?: Array<Properties> | Properties | null | undefined;
    /**
     * Generate extra `<meta>`s with these properties (optional); passed as
     * `properties` to [`hastscript`](https://github.com/syntax-tree/hastscript)
     * with `'meta'`.
     */
    meta?: Array<Properties> | Properties | null | undefined;
    /**
     * Generate a `meta[viewport]` (default: `true`).
     */
    responsive?: boolean | null | undefined;
    /**
     * JavaScript source code of `<script>`s to add at end of `body` (optional).
     */
    script?: Array<string> | string | null | undefined;
    /**
     * CSS source code of `<style>`s to add (optional).
     */
    style?: Array<string> | string | null | undefined;
    /**
     * Text to use as title (optional); defaults to the file name (if any); can
     * bet set with `file.data.matter.title` (`vfile-matter`) and
     * `file.data.meta.title` (`rehype-infer-title-meta`), which are preferred.
     */
    title?: string | null | undefined;
};
