"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuLink = exports.filterMenuLinkProps = exports.MENU_LINK_CLASSNAME = exports.menuLinkStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const HeaderSubMenu_1 = require("./HeaderSubMenu");
const mediaQueries_1 = require("../../mediaQueries");
const Text_1 = require("../../Text");
const util_1 = require("../../util");
const menuLinkStyle = (theme, _a) => {
    var { bold = true, color = theme.general.color, fontSize = theme.fontSizes.extraSmall, textTransform = 'uppercase', button = false } = _a, props = __rest(_a, ["bold", "color", "fontSize", "textTransform", "button"]);
    return (Object.assign(Object.assign({}, (0, Text_1.linkStyle)(theme, Object.assign({ bold, color, fontSize, textTransform }, props))), { [mediaQueries_1.media[mediaQueries_1.QueryKeys.DESKTOP]]: {
            '&:first-of-type': {
                marginLeft: 0,
            },
            '&:last-of-type': {
                marginRight: 0,
            },
            margin: '0 26px 0 10px',
            [`.${HeaderSubMenu_1.DESKTOP_HEADER_SUB_MENU_CLASSNAME} &`]: {
                '&:first-of-type': {
                    marginLeft: '10px',
                },
                '&:last-of-type': {
                    marginRight: '26px',
                },
            },
        }, [mediaQueries_1.media[mediaQueries_1.QueryKeys.TABLET_DOWN]]: {
            border: 'none',
            fontSize: '2rem !important',
            fontWeight: 400,
            maxWidth: '480px',
            padding: '8px 24px',
            textTransform: 'none !important',
        }, border: button ? '1px solid rgb(219, 226, 231)' : undefined, borderRadius: button ? '4px' : undefined, padding: button ? '10px 16px' : undefined }));
};
exports.menuLinkStyle = menuLinkStyle;
exports.MENU_LINK_CLASSNAME = 'menu-link';
const filterMenuLinkProps = (props) => (0, util_1.filterProps)((0, Text_1.filterLinkProps)(props), ['button']);
exports.filterMenuLinkProps = filterMenuLinkProps;
const MenuLink = (props) => ((0, jsx_runtime_1.jsx)("a", Object.assign({ className: exports.MENU_LINK_CLASSNAME, css: (theme) => (0, exports.menuLinkStyle)(theme, props) }, (0, exports.filterMenuLinkProps)(props))));
exports.MenuLink = MenuLink;
