/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.hyperlink;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class LinkModel
implements Comparable {
    private static final Logger LOG = Logger.getLogger(LinkModel.class.getName());
    private String text;
    private URL url;
    private String target;
    private boolean visited = false;
    private PropertyChangeSupport propertyChangeSupport;
    public static final String VISITED_PROPERTY = "visited";
    private static String defaultURLString = "https://jdnc.dev.java.net";
    private static URL defaultURL;

    public LinkModel(String text, String target, URL url) {
        this.setText(text);
        this.setTarget(target);
        this.setURL(url != null ? url : this.getDefaultURL());
    }

    public LinkModel() {
        this(" ", null, null);
    }

    public LinkModel(String text) {
        this(text, null, null);
    }

    public LinkModel(String text, String target, String template, String[] args2) {
        this.setText(text);
        this.setTarget(target);
        this.setURL(this.createURL(template, args2));
    }

    public void setText(String text) {
        String old = this.getText();
        this.text = text;
        this.firePropertyChange("text", old, this.getText());
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.url != null) {
            return this.getURL().toString();
        }
        return null;
    }

    public void setURLString(String howToURLString) {
        URL url = null;
        try {
            url = new URL(howToURLString);
        }
        catch (MalformedURLException e) {
            url = this.getDefaultURL();
            LOG.warning("the given urlString is malformed: " + howToURLString + "\n falling back to default url: " + url);
        }
        this.setURL(url);
    }

    private URL getDefaultURL() {
        if (defaultURL == null) {
            try {
                defaultURL = new URL(defaultURLString);
            }
            catch (MalformedURLException e) {
                LOG.fine("should not happen - defaultURL is wellFormed: " + defaultURLString);
            }
        }
        return defaultURL;
    }

    public void setURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL for link cannot be null");
        }
        if (url.equals(this.getURL())) {
            return;
        }
        URL old = this.getURL();
        this.url = url;
        this.firePropertyChange("URL", old, url);
        this.setVisited(false);
    }

    public URL getURL() {
        return this.url;
    }

    private URL createURL(String template, String[] args2) {
        URL url = null;
        try {
            String urlStr = template;
            for (int i = 0; i < args2.length; ++i) {
                urlStr = urlStr.replaceAll("@\\{" + (i + 1) + "\\}", args2[i]);
            }
            url = new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        return url;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        return "_blank";
    }

    public void setVisited(boolean visited) {
        boolean old = this.getVisited();
        this.visited = visited;
        this.firePropertyChange(VISITED_PROPERTY, old, this.getVisited());
    }

    public boolean getVisited() {
        return this.visited;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
    }

    protected void firePropertyChange(String property, boolean oldValue, boolean newValue) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 1;
        }
        if (obj == this) {
            return 0;
        }
        return this.text.compareTo(((LinkModel)obj).text);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof LinkModel) {
            LinkModel other = (LinkModel)obj;
            if (!this.getText().equals(other.getText())) {
                return false;
            }
            if (!this.getTarget().equals(other.getTarget())) {
                return false;
            }
            return this.getURL().equals(other.getURL());
        }
        return false;
    }

    public int hashCode() {
        int result = 7;
        result = 37 * result + (this.getText() == null ? 0 : this.getText().hashCode());
        result = 37 * result + (this.getTarget() == null ? 1 : this.getTarget().hashCode());
        result = 37 * result + (this.getURL() == null ? 2 : this.getURL().hashCode());
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        buffer.append("url=");
        buffer.append(this.url);
        buffer.append(", target=");
        buffer.append(this.target);
        buffer.append(", text=");
        buffer.append(this.text);
        buffer.append("]");
        return buffer.toString();
    }
}

