/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.tableview2.filter.popupfilter;

import impl.org.controlsfx.tableview2.filter.parser.string.StringParser;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.StringConverter;
import org.controlsfx.control.tableview2.FilteredTableColumn;
import org.controlsfx.control.tableview2.filter.parser.Parser;
import org.controlsfx.control.tableview2.filter.popupfilter.PopupFilter;

public class PopupStringFilter<S, T>
extends PopupFilter<S, T> {
    private final StringParser<T> stringParser;
    private final BooleanProperty caseSensitive = new SimpleBooleanProperty(this, "caseSensitive", true){

        @Override
        protected void invalidated() {
            PopupStringFilter.this.stringParser.setCaseSensitive(this.get());
        }
    };
    private final ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter", PopupStringFilter.defaultStringConverter()){

        @Override
        protected void invalidated() {
            PopupStringFilter.this.stringParser.setConverter((StringConverter)this.get());
        }
    };

    private static <T> StringConverter<T> defaultStringConverter() {
        return new StringConverter<T>(){

            @Override
            public String toString(T t) {
                return t == null ? null : t.toString();
            }

            @Override
            public T fromString(String string) {
                return string;
            }
        };
    }

    public PopupStringFilter(FilteredTableColumn<S, T> tableColumn) {
        super(tableColumn);
        this.stringParser = new StringParser<T>(this.caseSensitive.get(), this.getConverter());
        this.text.addListener((obs, ov, nv) -> {
            if (nv == null || nv.isEmpty()) {
                tableColumn.setPredicate(null);
            } else {
                tableColumn.setPredicate(this.getParser().parse((String)nv));
            }
        });
    }

    @Override
    public List<String> getOperations() {
        return this.stringParser.operators();
    }

    @Override
    public Parser<T> getParser() {
        return this.stringParser;
    }

    public final BooleanProperty caseSensitiveProperty() {
        return this.caseSensitive;
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }
}

