/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.UpdateLog;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UpdateConfig {
    private static final String ELEMENT_ROOT = "updateConfig";
    private static final String VERSION = "version";
    private static final String FILE = "file";
    private static final String INSTALL_TIMESTAMP = "installTimestamp";
    private static final String CANCEL_TIMESTAMP = "cancelTimestamp";
    private static final String TRY_COUNT = "tryCount";
    private static final String MAX_TRIES = "maxTries";
    private static final String CANCEL_COUNT = "cancelCount";
    private static final String MAX_CANCEL_COUNT = "maxCancelCount";
    private static final String RETRY_INHIBITION = "retryInhibition";
    private static final String SUCCESS = "success";
    private static final String INSTALLATION_DIRECTORY = "installationDirectory";
    private static final String LANGUAGE_ID = "languageId";
    private static final String CHECK_NEWER_VERSION = "checkNewerVersion";
    public static final String ELEMENT_UPDATE_ARGUMENTS = "updateArguments";
    public static final String ELEMENT_ARGUMENT = "argument";
    public static final String CONFIG_NAME = "config.xml";
    public static final int MACOS_ARCHIVE_RETRY_INHIBITION_MINUTES = 1440;
    public static final int DEFAULT_RETRY_INHIBITION_MINUTES = 1440;
    private final Element element;

    private UpdateConfig(Element element) {
        this.element = element;
    }

    public String getVersion() {
        return XmlHelper.readAttribute(this.element, VERSION, "");
    }

    public void setVersion(String value) {
        this.element.setAttribute(VERSION, value);
    }

    public String getFile() {
        return XmlHelper.readAttribute(this.element, FILE, "");
    }

    public void setFile(String value) {
        this.element.setAttribute(FILE, value);
    }

    public long getInstallTimestamp() {
        return XmlHelper.readAttribute(this.element, INSTALL_TIMESTAMP, 0L);
    }

    public void setInstallTimestamp(long value) {
        this.element.setAttribute(INSTALL_TIMESTAMP, String.valueOf(value));
    }

    public int getRetryInhibitionMinutes() {
        return XmlHelper.readAttribute(this.element, RETRY_INHIBITION, 1440);
    }

    public void setRetryInhibitionMinutes(int value) {
        this.element.setAttribute(RETRY_INHIBITION, String.valueOf(value));
    }

    public int getMaxTries() {
        return XmlHelper.readAttribute(this.element, MAX_TRIES, 1);
    }

    public void setMaxTries(int value) {
        this.element.setAttribute(MAX_TRIES, String.valueOf(value));
    }

    public int getTryCount() {
        return XmlHelper.readAttribute(this.element, TRY_COUNT, 0);
    }

    public void setTryCount(int value) {
        this.element.setAttribute(TRY_COUNT, String.valueOf(value));
    }

    public int getMaxCancelCount() {
        return XmlHelper.readAttribute(this.element, MAX_CANCEL_COUNT, 10);
    }

    public void setMaxCancelCount(int value) {
        this.element.setAttribute(MAX_CANCEL_COUNT, String.valueOf(value));
    }

    public int getCancelCount() {
        return XmlHelper.readAttribute(this.element, CANCEL_COUNT, 0);
    }

    public void setCancelCount(int value) {
        this.element.setAttribute(CANCEL_TIMESTAMP, String.valueOf(System.currentTimeMillis()));
        this.element.setAttribute(CANCEL_COUNT, String.valueOf(value));
    }

    public long getCancelTimestamp() {
        return XmlHelper.readAttribute(this.element, CANCEL_TIMESTAMP, 0L);
    }

    public boolean isSuccess() {
        return XmlHelper.readAttribute(this.element, SUCCESS, false);
    }

    public void setSuccess(boolean value) {
        this.element.setAttribute(SUCCESS, String.valueOf(value));
    }

    public void setInstallationDirectory(String value) {
        this.element.setAttribute(INSTALLATION_DIRECTORY, value);
    }

    public String getInstallationDirectory() {
        return XmlHelper.readAttribute(this.element, INSTALLATION_DIRECTORY, "");
    }

    public void setLanguageId(String value) {
        this.element.setAttribute(LANGUAGE_ID, value);
    }

    public String getLanguageId() {
        return XmlHelper.readAttribute(this.element, LANGUAGE_ID, "");
    }

    public List<String> getArguments() {
        return UpdateConfig.getArguments(this.element);
    }

    public void setArguments(List<String> value) {
        UpdateConfig.setArguments(this.element, value);
    }

    public boolean isCheckNewerVersion() {
        return XmlHelper.readAttribute(this.element, CHECK_NEWER_VERSION, false);
    }

    public void setCheckNewerVersion(boolean value) {
        this.element.setAttribute(CHECK_NEWER_VERSION, String.valueOf(value));
    }

    public void clear() {
        Node child = this.element.getFirstChild();
        while (child != null) {
            this.element.removeChild(child);
            child = this.element.getFirstChild();
        }
        NamedNodeMap attributes = this.element.getAttributes();
        while (attributes.getLength() > 0) {
            Node att = attributes.item(0);
            attributes.removeNamedItem(att.getNodeName());
        }
    }

    public static void withConfig(boolean create, ConfigConsumer configConsumer) {
        UpdateConfig.withConfig(UpdateConfig.getConfigFile(), create, configConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withConfig(File configFile, boolean create, ConfigConsumer configConsumer) {
        if (!create && !configFile.isFile()) {
            return;
        }
        boolean error = false;
        RandomAccessFile raFile = null;
        try {
            File parentDir = configFile.getParentFile();
            parentDir.mkdirs();
            raFile = new RandomAccessFile(configFile, "rw");
            UpdateLog.log(20, "trying to lock " + configFile);
            if (UpdateConfig.tryLock(raFile.getChannel(), 40)) {
                Document document;
                UpdateLog.log(20, "locked " + configFile);
                int length = (int)raFile.length();
                if (length == 0) {
                    document = XmlHelper.createDocument();
                    Element root = document.createElement(ELEMENT_ROOT);
                    document.appendChild(root);
                } else {
                    byte[] data = new byte[length];
                    raFile.readFully(data);
                    document = XmlHelper.parse(data);
                }
                if (configConsumer.handleConfig(new UpdateConfig(document.getDocumentElement()))) {
                    raFile.setLength(0L);
                    raFile.seek(0L);
                    raFile.write(XmlHelper.getBytes(document));
                    UpdateConfig.updateModifiedDir(parentDir);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            UpdateLog.log(e);
            error = true;
        }
        finally {
            try {
                if (raFile != null) {
                    raFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (error && configFile.isFile()) {
                configFile.delete();
            }
        }
    }

    private static void updateModifiedDir(File updateDir) {
        try {
            long currentTime = System.currentTimeMillis();
            updateDir.setLastModified(currentTime);
            File grandParent = updateDir.getParentFile();
            if (grandParent != null) {
                grandParent.setLastModified(currentTime);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            UpdateLog.log(e);
        }
    }

    static File getConfigFile() {
        return new File(AutomaticUpdate.getUpdateDir(), CONFIG_NAME);
    }

    public static boolean tryLock(FileChannel channel, int tryCount) throws IOException {
        for (int i = 0; i < tryCount; ++i) {
            FileLock readLock = channel.tryLock(0L, Long.MAX_VALUE, false);
            if (readLock != null) {
                return true;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                UpdateLog.log(e);
                e.printStackTrace();
            }
        }
        return false;
    }

    public static List<String> getArguments(Element element) {
        ArrayList<String> ret = new ArrayList<String>();
        Element argumentsElement = XmlHelper.findChild(element, ELEMENT_UPDATE_ARGUMENTS);
        if (argumentsElement != null) {
            for (Element argumentElement : XmlHelper.childElements(argumentsElement)) {
                ret.add(argumentElement.getTextContent());
            }
        }
        return ret;
    }

    private static void setArguments(Element element, List<String> arguments) {
        Element argumentsElement = XmlHelper.findChild(element, ELEMENT_UPDATE_ARGUMENTS);
        if (argumentsElement != null) {
            element.removeChild(argumentsElement);
        }
        Document document = element.getOwnerDocument();
        argumentsElement = document.createElement(ELEMENT_UPDATE_ARGUMENTS);
        element.appendChild(argumentsElement);
        for (String argument : arguments) {
            Element argumentElement = document.createElement(ELEMENT_ARGUMENT);
            argumentElement.setTextContent(argument);
            argumentsElement.appendChild(argumentElement);
        }
    }

    public static interface ConfigConsumer {
        public boolean handleConfig(UpdateConfig var1) throws IOException;
    }
}

