// This file was generated by qtwaylandscanner
// source file is color-management-v1.xml

#ifndef QT_WAYLAND_SERVER_COLOR_MANAGEMENT_V1
#define QT_WAYLAND_SERVER_COLOR_MANAGEMENT_V1

#include "wayland-server-core.h"
#include "wayland-color-management-v1-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  wp_color_manager_v1
    {
    public:
        wp_color_manager_v1(struct ::wl_client *client, int id, int version);
        wp_color_manager_v1(struct ::wl_display *display, int version);
        wp_color_manager_v1(struct ::wl_resource *resource);
        wp_color_manager_v1();

        virtual ~wp_color_manager_v1();

        class Resource
        {
        public:
            Resource() : wp_color_manager_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_color_manager_v1 *wp_color_manager_v1_object;
            wp_color_manager_v1 *object() { return wp_color_manager_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_unsupported_feature = 0, // request not supported
            error_surface_exists = 1, // color management surface exists already
        };

        enum render_intent {
            render_intent_perceptual = 0, // perceptual
            render_intent_relative = 1, // media-relative colorimetric
            render_intent_saturation = 2, // saturation
            render_intent_absolute = 3, // ICC-absolute colorimetric
            render_intent_relative_bpc = 4, // media-relative colorimetric + black point compensation
        };

        enum feature {
            feature_icc_v2_v4 = 0, // create_icc_creator request
            feature_parametric = 1, // create_parametric_creator request
            feature_set_primaries = 2, // parametric set_primaries request
            feature_set_tf_power = 3, // parametric set_tf_power request
            feature_set_luminances = 4, // parametric set_luminances request
            feature_set_mastering_display_primaries = 5,
            feature_extended_target_volume = 6,
            feature_windows_scrgb = 7, // create_windows_scrgb request
        };

        enum primaries {
            primaries_srgb = 1,
            primaries_pal_m = 2,
            primaries_pal = 3,
            primaries_ntsc = 4,
            primaries_generic_film = 5,
            primaries_bt2020 = 6,
            primaries_cie1931_xyz = 7,
            primaries_dci_p3 = 8,
            primaries_display_p3 = 9,
            primaries_adobe_rgb = 10,
        };

        enum transfer_function {
            transfer_function_bt1886 = 1,
            transfer_function_gamma22 = 2,
            transfer_function_gamma28 = 3,
            transfer_function_st240 = 4,
            transfer_function_ext_linear = 5,
            transfer_function_log_100 = 6,
            transfer_function_log_316 = 7,
            transfer_function_xvycc = 8,
            transfer_function_srgb = 9,
            transfer_function_ext_srgb = 10,
            transfer_function_st2084_pq = 11,
            transfer_function_st428 = 12,
            transfer_function_hlg = 13,
        };

        void send_supported_intent(uint32_t render_intent);
        void send_supported_intent(struct ::wl_resource *resource, uint32_t render_intent);
        void send_supported_feature(uint32_t feature);
        void send_supported_feature(struct ::wl_resource *resource, uint32_t feature);
        void send_supported_tf_named(uint32_t tf);
        void send_supported_tf_named(struct ::wl_resource *resource, uint32_t tf);
        void send_supported_primaries_named(uint32_t primaries);
        void send_supported_primaries_named(struct ::wl_resource *resource, uint32_t primaries);
        void send_done();
        void send_done(struct ::wl_resource *resource);

    protected:
        virtual Resource *wp_color_manager_v1_allocate();

        virtual void wp_color_manager_v1_destroy_global();

        virtual void wp_color_manager_v1_bind_resource(Resource *resource);
        virtual void wp_color_manager_v1_destroy_resource(Resource *resource);

        virtual void wp_color_manager_v1_destroy(Resource *resource);
        virtual void wp_color_manager_v1_get_output(Resource *resource, uint32_t id, struct ::wl_resource *output);
        virtual void wp_color_manager_v1_get_surface(Resource *resource, uint32_t id, struct ::wl_resource *surface);
        virtual void wp_color_manager_v1_get_surface_feedback(Resource *resource, uint32_t id, struct ::wl_resource *surface);
        virtual void wp_color_manager_v1_create_icc_creator(Resource *resource, uint32_t obj);
        virtual void wp_color_manager_v1_create_parametric_creator(Resource *resource, uint32_t obj);
        virtual void wp_color_manager_v1_create_windows_scrgb(Resource *resource, uint32_t image_description);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_color_manager_v1_interface m_wp_color_manager_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_get_output(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *output);
        static void handle_get_surface(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *surface);
        static void handle_get_surface_feedback(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id,
            struct ::wl_resource *surface);
        static void handle_create_icc_creator(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t obj);
        static void handle_create_parametric_creator(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t obj);
        static void handle_create_windows_scrgb(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t image_description);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_color_manager_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_color_management_output_v1
    {
    public:
        wp_color_management_output_v1(struct ::wl_client *client, int id, int version);
        wp_color_management_output_v1(struct ::wl_display *display, int version);
        wp_color_management_output_v1(struct ::wl_resource *resource);
        wp_color_management_output_v1();

        virtual ~wp_color_management_output_v1();

        class Resource
        {
        public:
            Resource() : wp_color_management_output_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_color_management_output_v1 *wp_color_management_output_v1_object;
            wp_color_management_output_v1 *object() { return wp_color_management_output_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_image_description_changed();
        void send_image_description_changed(struct ::wl_resource *resource);

    protected:
        virtual Resource *wp_color_management_output_v1_allocate();

        virtual void wp_color_management_output_v1_destroy_global();

        virtual void wp_color_management_output_v1_bind_resource(Resource *resource);
        virtual void wp_color_management_output_v1_destroy_resource(Resource *resource);

        virtual void wp_color_management_output_v1_destroy(Resource *resource);
        virtual void wp_color_management_output_v1_get_image_description(Resource *resource, uint32_t image_description);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_color_management_output_v1_interface m_wp_color_management_output_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_get_image_description(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t image_description);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_color_management_output_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_color_management_surface_v1
    {
    public:
        wp_color_management_surface_v1(struct ::wl_client *client, int id, int version);
        wp_color_management_surface_v1(struct ::wl_display *display, int version);
        wp_color_management_surface_v1(struct ::wl_resource *resource);
        wp_color_management_surface_v1();

        virtual ~wp_color_management_surface_v1();

        class Resource
        {
        public:
            Resource() : wp_color_management_surface_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_color_management_surface_v1 *wp_color_management_surface_v1_object;
            wp_color_management_surface_v1 *object() { return wp_color_management_surface_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_render_intent = 0, // unsupported rendering intent
            error_image_description = 1, // invalid image description
            error_inert = 2, // forbidden request on inert object
        };

    protected:
        virtual Resource *wp_color_management_surface_v1_allocate();

        virtual void wp_color_management_surface_v1_destroy_global();

        virtual void wp_color_management_surface_v1_bind_resource(Resource *resource);
        virtual void wp_color_management_surface_v1_destroy_resource(Resource *resource);

        virtual void wp_color_management_surface_v1_destroy(Resource *resource);
        virtual void wp_color_management_surface_v1_set_image_description(Resource *resource, struct ::wl_resource *image_description, uint32_t render_intent);
        virtual void wp_color_management_surface_v1_unset_image_description(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_color_management_surface_v1_interface m_wp_color_management_surface_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_set_image_description(
            ::wl_client *client,
            struct wl_resource *resource,
            struct ::wl_resource *image_description,
            uint32_t render_intent);
        static void handle_unset_image_description(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_color_management_surface_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_color_management_surface_feedback_v1
    {
    public:
        wp_color_management_surface_feedback_v1(struct ::wl_client *client, int id, int version);
        wp_color_management_surface_feedback_v1(struct ::wl_display *display, int version);
        wp_color_management_surface_feedback_v1(struct ::wl_resource *resource);
        wp_color_management_surface_feedback_v1();

        virtual ~wp_color_management_surface_feedback_v1();

        class Resource
        {
        public:
            Resource() : wp_color_management_surface_feedback_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_color_management_surface_feedback_v1 *wp_color_management_surface_feedback_v1_object;
            wp_color_management_surface_feedback_v1 *object() { return wp_color_management_surface_feedback_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_inert = 0, // forbidden request on inert object
            error_unsupported_feature = 1, // attempted to use an unsupported feature
        };

        void send_preferred_changed(uint32_t identity);
        void send_preferred_changed(struct ::wl_resource *resource, uint32_t identity);

    protected:
        virtual Resource *wp_color_management_surface_feedback_v1_allocate();

        virtual void wp_color_management_surface_feedback_v1_destroy_global();

        virtual void wp_color_management_surface_feedback_v1_bind_resource(Resource *resource);
        virtual void wp_color_management_surface_feedback_v1_destroy_resource(Resource *resource);

        virtual void wp_color_management_surface_feedback_v1_destroy(Resource *resource);
        virtual void wp_color_management_surface_feedback_v1_get_preferred(Resource *resource, uint32_t image_description);
        virtual void wp_color_management_surface_feedback_v1_get_preferred_parametric(Resource *resource, uint32_t image_description);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_color_management_surface_feedback_v1_interface m_wp_color_management_surface_feedback_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_get_preferred(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t image_description);
        static void handle_get_preferred_parametric(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t image_description);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_color_management_surface_feedback_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_image_description_creator_icc_v1
    {
    public:
        wp_image_description_creator_icc_v1(struct ::wl_client *client, int id, int version);
        wp_image_description_creator_icc_v1(struct ::wl_display *display, int version);
        wp_image_description_creator_icc_v1(struct ::wl_resource *resource);
        wp_image_description_creator_icc_v1();

        virtual ~wp_image_description_creator_icc_v1();

        class Resource
        {
        public:
            Resource() : wp_image_description_creator_icc_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_image_description_creator_icc_v1 *wp_image_description_creator_icc_v1_object;
            wp_image_description_creator_icc_v1 *object() { return wp_image_description_creator_icc_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_incomplete_set = 0, // incomplete parameter set
            error_already_set = 1, // property already set
            error_bad_fd = 2, // fd not seekable and readable
            error_bad_size = 3, // no or too much data
            error_out_of_file = 4, // offset + length exceeds file size
        };

    protected:
        virtual Resource *wp_image_description_creator_icc_v1_allocate();

        virtual void wp_image_description_creator_icc_v1_destroy_global();

        virtual void wp_image_description_creator_icc_v1_bind_resource(Resource *resource);
        virtual void wp_image_description_creator_icc_v1_destroy_resource(Resource *resource);

        virtual void wp_image_description_creator_icc_v1_create(Resource *resource, uint32_t image_description);
        virtual void wp_image_description_creator_icc_v1_set_icc_file(Resource *resource, int32_t icc_profile, uint32_t offset, uint32_t length);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_image_description_creator_icc_v1_interface m_wp_image_description_creator_icc_v1_interface;

        static void handle_create(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t image_description);
        static void handle_set_icc_file(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t icc_profile,
            uint32_t offset,
            uint32_t length);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_image_description_creator_icc_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_image_description_creator_params_v1
    {
    public:
        wp_image_description_creator_params_v1(struct ::wl_client *client, int id, int version);
        wp_image_description_creator_params_v1(struct ::wl_display *display, int version);
        wp_image_description_creator_params_v1(struct ::wl_resource *resource);
        wp_image_description_creator_params_v1();

        virtual ~wp_image_description_creator_params_v1();

        class Resource
        {
        public:
            Resource() : wp_image_description_creator_params_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_image_description_creator_params_v1 *wp_image_description_creator_params_v1_object;
            wp_image_description_creator_params_v1 *object() { return wp_image_description_creator_params_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_incomplete_set = 0, // incomplete parameter set
            error_already_set = 1, // property already set
            error_unsupported_feature = 2, // request not supported
            error_invalid_tf = 3, // invalid transfer characteristic
            error_invalid_primaries_named = 4, // invalid primaries named
            error_invalid_luminance = 5, // invalid luminance value or range
        };

    protected:
        virtual Resource *wp_image_description_creator_params_v1_allocate();

        virtual void wp_image_description_creator_params_v1_destroy_global();

        virtual void wp_image_description_creator_params_v1_bind_resource(Resource *resource);
        virtual void wp_image_description_creator_params_v1_destroy_resource(Resource *resource);

        virtual void wp_image_description_creator_params_v1_create(Resource *resource, uint32_t image_description);
        virtual void wp_image_description_creator_params_v1_set_tf_named(Resource *resource, uint32_t tf);
        virtual void wp_image_description_creator_params_v1_set_tf_power(Resource *resource, uint32_t eexp);
        virtual void wp_image_description_creator_params_v1_set_primaries_named(Resource *resource, uint32_t primaries);
        virtual void wp_image_description_creator_params_v1_set_primaries(Resource *resource, int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y);
        virtual void wp_image_description_creator_params_v1_set_luminances(Resource *resource, uint32_t min_lum, uint32_t max_lum, uint32_t reference_lum);
        virtual void wp_image_description_creator_params_v1_set_mastering_display_primaries(Resource *resource, int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y);
        virtual void wp_image_description_creator_params_v1_set_mastering_luminance(Resource *resource, uint32_t min_lum, uint32_t max_lum);
        virtual void wp_image_description_creator_params_v1_set_max_cll(Resource *resource, uint32_t max_cll);
        virtual void wp_image_description_creator_params_v1_set_max_fall(Resource *resource, uint32_t max_fall);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_image_description_creator_params_v1_interface m_wp_image_description_creator_params_v1_interface;

        static void handle_create(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t image_description);
        static void handle_set_tf_named(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t tf);
        static void handle_set_tf_power(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t eexp);
        static void handle_set_primaries_named(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t primaries);
        static void handle_set_primaries(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t r_x,
            int32_t r_y,
            int32_t g_x,
            int32_t g_y,
            int32_t b_x,
            int32_t b_y,
            int32_t w_x,
            int32_t w_y);
        static void handle_set_luminances(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t min_lum,
            uint32_t max_lum,
            uint32_t reference_lum);
        static void handle_set_mastering_display_primaries(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t r_x,
            int32_t r_y,
            int32_t g_x,
            int32_t g_y,
            int32_t b_x,
            int32_t b_y,
            int32_t w_x,
            int32_t w_y);
        static void handle_set_mastering_luminance(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t min_lum,
            uint32_t max_lum);
        static void handle_set_max_cll(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t max_cll);
        static void handle_set_max_fall(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t max_fall);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_image_description_creator_params_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_image_description_v1
    {
    public:
        wp_image_description_v1(struct ::wl_client *client, int id, int version);
        wp_image_description_v1(struct ::wl_display *display, int version);
        wp_image_description_v1(struct ::wl_resource *resource);
        wp_image_description_v1();

        virtual ~wp_image_description_v1();

        class Resource
        {
        public:
            Resource() : wp_image_description_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_image_description_v1 *wp_image_description_v1_object;
            wp_image_description_v1 *object() { return wp_image_description_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum error {
            error_not_ready = 0, // attempted to use an object which is not ready
            error_no_information = 1, // get_information not allowed
        };

        enum cause {
            cause_low_version = 0, // interface version too low
            cause_unsupported = 1, // unsupported image description data
            cause_operating_system = 2, // error independent of the client
            cause_no_output = 3, // the relevant output no longer exists
        };

        void send_failed(uint32_t cause, const QString &msg);
        void send_failed(struct ::wl_resource *resource, uint32_t cause, const QString &msg);
        void send_ready(uint32_t identity);
        void send_ready(struct ::wl_resource *resource, uint32_t identity);

    protected:
        virtual Resource *wp_image_description_v1_allocate();

        virtual void wp_image_description_v1_destroy_global();

        virtual void wp_image_description_v1_bind_resource(Resource *resource);
        virtual void wp_image_description_v1_destroy_resource(Resource *resource);

        virtual void wp_image_description_v1_destroy(Resource *resource);
        virtual void wp_image_description_v1_get_information(Resource *resource, uint32_t information);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::wp_image_description_v1_interface m_wp_image_description_v1_interface;

        static void handle_destroy(
            ::wl_client *client,
            struct wl_resource *resource);
        static void handle_get_information(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t information);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_image_description_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  wp_image_description_info_v1
    {
    public:
        wp_image_description_info_v1(struct ::wl_client *client, int id, int version);
        wp_image_description_info_v1(struct ::wl_display *display, int version);
        wp_image_description_info_v1(struct ::wl_resource *resource);
        wp_image_description_info_v1();

        virtual ~wp_image_description_info_v1();

        class Resource
        {
        public:
            Resource() : wp_image_description_info_v1_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            wp_image_description_info_v1 *wp_image_description_info_v1_object;
            wp_image_description_info_v1 *object() { return wp_image_description_info_v1_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_done();
        void send_done(struct ::wl_resource *resource);
        void send_icc_file(int32_t icc, uint32_t icc_size);
        void send_icc_file(struct ::wl_resource *resource, int32_t icc, uint32_t icc_size);
        void send_primaries(int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y);
        void send_primaries(struct ::wl_resource *resource, int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y);
        void send_primaries_named(uint32_t primaries);
        void send_primaries_named(struct ::wl_resource *resource, uint32_t primaries);
        void send_tf_power(uint32_t eexp);
        void send_tf_power(struct ::wl_resource *resource, uint32_t eexp);
        void send_tf_named(uint32_t tf);
        void send_tf_named(struct ::wl_resource *resource, uint32_t tf);
        void send_luminances(uint32_t min_lum, uint32_t max_lum, uint32_t reference_lum);
        void send_luminances(struct ::wl_resource *resource, uint32_t min_lum, uint32_t max_lum, uint32_t reference_lum);
        void send_target_primaries(int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y);
        void send_target_primaries(struct ::wl_resource *resource, int32_t r_x, int32_t r_y, int32_t g_x, int32_t g_y, int32_t b_x, int32_t b_y, int32_t w_x, int32_t w_y);
        void send_target_luminance(uint32_t min_lum, uint32_t max_lum);
        void send_target_luminance(struct ::wl_resource *resource, uint32_t min_lum, uint32_t max_lum);
        void send_target_max_cll(uint32_t max_cll);
        void send_target_max_cll(struct ::wl_resource *resource, uint32_t max_cll);
        void send_target_max_fall(uint32_t max_fall);
        void send_target_max_fall(struct ::wl_resource *resource, uint32_t max_fall);

    protected:
        virtual Resource *wp_image_description_info_v1_allocate();

        virtual void wp_image_description_info_v1_destroy_global();

        virtual void wp_image_description_info_v1_bind_resource(Resource *resource);
        virtual void wp_image_description_info_v1_destroy_resource(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            wp_image_description_info_v1 *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
