/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gephi.graph.api.GraphLock;

public class GraphLockImpl
implements GraphLock {
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    protected final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public void readUnlockAll() {
        int nReadLocks = this.readWriteLock.getReadHoldCount();
        for (int n = 0; n < nReadLocks; ++n) {
            this.readLock.unlock();
        }
    }

    @Override
    public void writeLock() {
        if (this.readWriteLock.getReadHoldCount() > 0 && !this.readWriteLock.isWriteLockedByCurrentThread()) {
            throw new IllegalMonitorStateException("Impossible to acquire a write lock when currently holding a read lock. Use toArray() methods on NodeIterable and EdgeIterable to avoid holding a readLock or wrap your loop with a write lock.");
        }
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }

    @Override
    public int getReadHoldCount() {
        return this.readWriteLock.getReadHoldCount();
    }

    @Override
    public int getWriteHoldCount() {
        return this.readWriteLock.getWriteHoldCount();
    }

    public void checkHoldWriteLock() {
        if (!this.readWriteLock.isWriteLockedByCurrentThread()) {
            throw new IllegalMonitorStateException("Impossible to perform a write operation without lock. Wrap your code with a write lock to solve this.");
        }
    }
}

