/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.Vec3d;
import org.gephi.lib.gleem.linalg.Vecf;

public class Vec3f {
    public static final Vec3f X_AXIS = new Vec3f(1.0f, 0.0f, 0.0f);
    public static final Vec3f Y_AXIS = new Vec3f(0.0f, 1.0f, 0.0f);
    public static final Vec3f Z_AXIS = new Vec3f(0.0f, 0.0f, 1.0f);
    public static final Vec3f NEG_X_AXIS = new Vec3f(-1.0f, 0.0f, 0.0f);
    public static final Vec3f NEG_Y_AXIS = new Vec3f(0.0f, -1.0f, 0.0f);
    public static final Vec3f NEG_Z_AXIS = new Vec3f(0.0f, 0.0f, -1.0f);
    private float x;
    private float y;
    private float z;

    public Vec3f() {
    }

    public Vec3f(Vec3f arg) {
        this.set(arg);
    }

    public Vec3f(float x, float y, float z) {
        this.set(x, y, z);
    }

    public Vec3f copy() {
        return new Vec3f(this);
    }

    public Vec3d toDouble() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public void set(Vec3f arg) {
        this.set(arg.x, arg.y, arg.z);
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(int i, float val) {
        switch (i) {
            case 0: {
                this.x = val;
                break;
            }
            case 1: {
                this.y = val;
                break;
            }
            case 2: {
                this.z = val;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public float get(int i) {
        switch (i) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public float dot(Vec3f arg) {
        return this.x * arg.x + this.y * arg.y + this.z * arg.z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public void normalize() {
        float len = this.length();
        if (len == 0.0f) {
            return;
        }
        this.scale(1.0f / len);
    }

    public Vec3f times(float val) {
        Vec3f tmp = new Vec3f(this);
        tmp.scale(val);
        return tmp;
    }

    public void scale(float val) {
        this.x *= val;
        this.y *= val;
        this.z *= val;
    }

    public Vec3f plus(Vec3f arg) {
        Vec3f tmp = new Vec3f();
        tmp.add(this, arg);
        return tmp;
    }

    public void add(Vec3f b) {
        this.add(this, b);
    }

    public void add(Vec3f a, Vec3f b) {
        this.x = a.x + b.x;
        this.y = a.y + b.y;
        this.z = a.z + b.z;
    }

    public Vec3f addScaled(float s, Vec3f arg) {
        Vec3f tmp = new Vec3f();
        tmp.addScaled(this, s, arg);
        return tmp;
    }

    public void addScaled(Vec3f a, float s, Vec3f b) {
        this.x = a.x + s * b.x;
        this.y = a.y + s * b.y;
        this.z = a.z + s * b.z;
    }

    public Vec3f minus(Vec3f arg) {
        Vec3f tmp = new Vec3f();
        tmp.sub(this, arg);
        return tmp;
    }

    public void sub(Vec3f b) {
        this.sub(this, b);
    }

    public void sub(Vec3f a, Vec3f b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
    }

    public Vec3f cross(Vec3f arg) {
        Vec3f tmp = new Vec3f();
        tmp.cross(this, arg);
        return tmp;
    }

    public void cross(Vec3f a, Vec3f b) {
        this.x = a.y * b.z - a.z * b.y;
        this.y = a.z * b.x - a.x * b.z;
        this.z = a.x * b.y - a.y * b.x;
    }

    public void componentMul(Vec3f arg) {
        this.x *= arg.x;
        this.y *= arg.y;
        this.z *= arg.z;
    }

    public Vecf toVecf() {
        Vecf out = new Vecf(3);
        for (int i = 0; i < 3; ++i) {
            out.set(i, this.get(i));
        }
        return out;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

