/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.swing.HomeTransferableList;
import com.eteks.sweethome3d.swing.LocatedTransferHandler;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.TransferableView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class PlanTransferHandler
extends LocatedTransferHandler {
    private final Home home;
    private final ContentManager contentManager;
    private final HomeController homeController;
    private List<Selectable> copiedItems;
    private Object copiedImage;
    private boolean isDragging;
    private WindowAdapter windowDeactivationListener;

    public PlanTransferHandler(Home home, ContentManager contentManager, HomeController homeController) {
        this.home = home;
        this.contentManager = contentManager;
        this.homeController = homeController;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        this.copiedItems = this.home.getSelectedItems();
        final HomeTransferableList homeTransferableList = new HomeTransferableList(this.copiedItems);
        if (jComponent instanceof TransferableView) {
            this.copiedImage = null;
            this.homeController.createTransferData(new TransferableView.TransferObserver(){

                @Override
                public void dataReady(Object[] objectArray) {
                    for (Object object : objectArray) {
                        if (!(object instanceof BufferedImage)) continue;
                        PlanTransferHandler.this.copiedImage = object;
                        break;
                    }
                }
            }, TransferableView.DataType.PLAN_IMAGE);
            return new Transferable(){
                final /* synthetic */ PlanTransferHandler this$0;
                {
                    this.this$0 = planTransferHandler;
                }

                @Override
                public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                    if (DataFlavor.imageFlavor.equals(dataFlavor)) {
                        return this.this$0.copiedImage;
                    }
                    return homeTransferableList.getTransferData(dataFlavor);
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(Arrays.asList(homeTransferableList.getTransferDataFlavors()));
                    arrayList.add(DataFlavor.imageFlavor);
                    return arrayList.toArray(new DataFlavor[arrayList.size()]);
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                    return homeTransferableList.isDataFlavorSupported(dataFlavor) || DataFlavor.imageFlavor.equals(dataFlavor);
                }
            };
        }
        return homeTransferableList;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2) {
            this.homeController.cut(this.copiedItems);
        }
        this.copiedItems = null;
        this.copiedImage = null;
        this.homeController.enablePasteAction();
    }

    @Override
    protected boolean canImportFlavor(DataFlavor[] dataFlavorArray) {
        Level level = this.home.getSelectedLevel();
        List<DataFlavor> list = Arrays.asList(dataFlavorArray);
        return (level == null || level.isViewable()) && (list.contains(HomeTransferableList.HOME_FLAVOR) && !SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), (JComponent)((Object)this.homeController.getFurnitureController().getView())) || list.contains(DataFlavor.javaFileListFlavor));
    }

    @Override
    protected void dragEntered(final JComponent jComponent, Transferable transferable, int n) {
        if (transferable.isDataFlavorSupported(HomeTransferableList.HOME_FLAVOR) && jComponent instanceof PlanView && this.homeController.getPlanController() != null) {
            try {
                List list = (List)transferable.getTransferData(HomeTransferableList.HOME_FLAVOR);
                Point2D point2D = this.getDropModelLocation(jComponent);
                this.homeController.getPlanController().startDraggedItems(list, (float)point2D.getX(), (float)point2D.getY());
                this.windowDeactivationListener = new WindowAdapter(this){
                    final /* synthetic */ PlanTransferHandler this$0;
                    {
                        this.this$0 = planTransferHandler;
                    }

                    @Override
                    public void windowDeactivated(WindowEvent windowEvent) {
                        this.this$0.dragExited(jComponent);
                    }
                };
                SwingUtilities.getWindowAncestor(jComponent).addWindowListener(this.windowDeactivationListener);
                this.isDragging = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                throw new RuntimeException("Can't import", unsupportedFlavorException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't access to data", iOException);
            }
        }
    }

    @Override
    protected void dragMoved(JComponent jComponent, Transferable transferable, int n) {
        if (transferable.isDataFlavorSupported(HomeTransferableList.HOME_FLAVOR) && jComponent instanceof PlanView && this.homeController.getPlanController() != null) {
            Point2D point2D = this.getDropModelLocation(jComponent);
            this.homeController.getPlanController().moveMouse((float)point2D.getX(), (float)point2D.getY());
        }
    }

    @Override
    protected void dragExited(JComponent jComponent) {
        if (this.isDragging) {
            SwingUtilities.getWindowAncestor(jComponent).removeWindowListener(this.windowDeactivationListener);
            this.homeController.getPlanController().stopDraggedItems();
            this.isDragging = false;
        }
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImportFlavor(transferable.getTransferDataFlavors())) {
            try {
                List<DataFlavor> list;
                if (this.isDragging) {
                    this.dragExited(jComponent);
                }
                if ((list = Arrays.asList(transferable.getTransferDataFlavors())).contains(HomeTransferableList.HOME_FLAVOR)) {
                    return this.importHomeTransferableList(jComponent, (List)transferable.getTransferData(HomeTransferableList.HOME_FLAVOR));
                }
                return this.importFileList(jComponent, (List)transferable.getTransferData(DataFlavor.javaFileListFlavor));
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                throw new RuntimeException("Can't import", unsupportedFlavorException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't access to data", iOException);
            }
        }
        return false;
    }

    private boolean importHomeTransferableList(JComponent jComponent, List<Selectable> list) {
        if (this.isDrop()) {
            Point2D point2D = this.getDropModelLocation(jComponent);
            if (jComponent instanceof View) {
                this.homeController.drop(list, this.homeController.getPlanController().getView(), (float)point2D.getX(), (float)point2D.getY());
            } else {
                this.homeController.drop(list, (float)point2D.getX(), (float)point2D.getY());
            }
        } else {
            this.homeController.paste(list);
        }
        return true;
    }

    private boolean importFileList(JComponent jComponent, List<File> list) {
        final Point2D point2D = this.isDrop() ? this.getDropModelLocation(jComponent) : new Point2D.Float();
        final List<String> list2 = this.getModelContents(list, this.contentManager);
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ PlanTransferHandler this$0;
            {
                this.this$0 = planTransferHandler;
            }

            @Override
            public void run() {
                this.this$0.homeController.dropFiles(list2, (float)point2D.getX(), (float)point2D.getY());
            }
        });
        return !list2.isEmpty();
    }

    private Point2D getDropModelLocation(JComponent jComponent) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (jComponent instanceof PlanView) {
            PlanView planView = (PlanView)((Object)jComponent);
            Point point = this.getDropLocation();
            SwingUtilities.convertPointFromScreen(point, jComponent);
            f = planView.convertXPixelToModel(point.x);
            f2 = planView.convertYPixelToModel(point.y);
        }
        return new Point2D.Float(f, f2);
    }
}

