/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.testdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Objects;
import us.fatehi.utility.SQLRuntimeException;
import us.fatehi.utility.database.SqlScript;
import us.fatehi.utility.ioresource.ClasspathInputResource;

public class TestSchemaCreator
implements Runnable {
    private final Connection connection;
    private final String scriptsResource;

    public static void executeScriptLine(String scriptResourceLine, Connection connection) {
        String delimiter;
        String scriptResource;
        Objects.requireNonNull(scriptResourceLine, "No script resource line provided");
        Objects.requireNonNull(connection, "No database connection provided");
        String[] split = scriptResourceLine.split(",");
        if (split.length == 1) {
            scriptResource = scriptResourceLine.trim();
            delimiter = scriptResource.isEmpty() ? "#" : ";";
        } else if (split.length == 2) {
            delimiter = split[0].trim();
            scriptResource = split[1].trim();
        } else {
            throw new SQLRuntimeException(String.format("Too many fields in \"%s\"", scriptResourceLine));
        }
        boolean skip = "#".equals(delimiter);
        if (skip) {
            return;
        }
        try (BufferedReader scriptReader = new ClasspathInputResource(scriptResource).openNewInputReader(StandardCharsets.UTF_8);){
            new SqlScript((Reader)scriptReader, delimiter, connection).run();
        }
        catch (IOException e) {
            throw new SQLRuntimeException(String.format("Could not read \"%s\"", scriptResource), (Throwable)e);
        }
    }

    public TestSchemaCreator(Connection connection, String scriptsResource) {
        this.connection = Objects.requireNonNull(connection, "No database connection provided");
        this.scriptsResource = Objects.requireNonNull(scriptsResource, "No script resource provided");
    }

    @Override
    public void run() {
        try (BufferedReader reader = new ClasspathInputResource(this.scriptsResource).openNewInputReader(StandardCharsets.UTF_8);){
            reader.lines().forEach(line -> TestSchemaCreator.executeScriptLine(line, this.connection));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

