/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Table;
import schemacrawler.schema.View;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintSeverity;
import us.fatehi.utility.property.PropertyName;

class LinterForeignKeyMismatch
extends BaseLinter {
    LinterForeignKeyMismatch(PropertyName linterName, LintCollector lintCollector) {
        super(linterName, lintCollector);
        this.setSeverity(LintSeverity.high);
    }

    @Override
    public String getSummary() {
        return "foreign key data type different from primary key";
    }

    @Override
    protected void lint(Table table, Connection connections) {
        Objects.requireNonNull(table, "No table provided");
        List<ForeignKey> mismatchedForeignKeys = this.findMismatchedForeignKeys(table);
        for (ForeignKey foreignKey : mismatchedForeignKeys) {
            this.addTableLint(table, this.getSummary(), foreignKey);
        }
    }

    private List<ForeignKey> findMismatchedForeignKeys(Table table) {
        ArrayList<ForeignKey> mismatchedForeignKeys = new ArrayList<ForeignKey>();
        if (table != null && !(table instanceof View)) {
            block0: for (ForeignKey foreignKey : table.getImportedForeignKeys()) {
                for (ColumnReference columnReference : foreignKey) {
                    Column fkColumn;
                    Column pkColumn = columnReference.getPrimaryKeyColumn();
                    if (!pkColumn.isColumnDataTypeKnown() || !(fkColumn = columnReference.getForeignKeyColumn()).isColumnDataTypeKnown() || pkColumn.getColumnDataType().getJavaSqlType().equals((Object)fkColumn.getColumnDataType().getJavaSqlType()) && pkColumn.getSize() == fkColumn.getSize()) continue;
                    mismatchedForeignKeys.add(foreignKey);
                    continue block0;
                }
            }
        }
        return mismatchedForeignKeys;
    }
}

