/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatement;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementSet;
import com.ibm.db2.cmx.runtime.internal.xml.XmlBuf;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import java.util.ArrayList;

public class PDQXmlPackage
implements XmlExporter {
    private String packageName_;
    private String collectionName_;
    private long consistencyToken_ = 0L;
    private String packageVersion_;
    private String bindOptions_;
    private boolean bindable_ = true;
    private boolean forceSingleBindIsolation_ = false;
    private boolean ddlPackage_ = false;
    private PDQXmlStatementSet parentStatementSet_;
    private int greatestSectionNumberUsed_ = 0;

    public void setParentStatementSet(PDQXmlStatementSet pDQXmlStatementSet) {
        this.parentStatementSet_ = pDQXmlStatementSet;
    }

    public String getCollectionName() {
        return this.collectionName_;
    }

    public void setCollectionName(String string) {
        this.collectionName_ = string;
    }

    public long getConsistencyToken() {
        return this.consistencyToken_;
    }

    public void setConsistencyToken(long l2) {
        this.consistencyToken_ = l2;
    }

    public void setConsistencyToken(byte[] byArray) {
        this.consistencyToken_ = StatementDescriptorImpl.bytesToTimestamp(byArray);
    }

    public void setConsistencyToken(String string) {
        byte[] byArray = StatementDescriptorImpl.stringToBytes(string);
        this.setConsistencyToken(byArray);
    }

    public String getPackageName() {
        return this.packageName_;
    }

    public void setPackageName(String string) {
        this.packageName_ = string;
    }

    public String getPackageVersion() {
        return this.packageVersion_;
    }

    public void setPackageVersion(String string) {
        this.packageVersion_ = string;
    }

    public int getGreatestSectionNumberUsed() {
        return this.greatestSectionNumberUsed_;
    }

    protected void setGreatestSectionNumberUsed(int n2) {
        this.greatestSectionNumberUsed_ = n2;
    }

    public void setGreatestSectionNumberUsedBasedOnAssignedSectionNumbersAndReservedSections() {
        ArrayList<PDQXmlStatement> arrayList;
        this.greatestSectionNumberUsed_ = 0;
        if (null != this.parentStatementSet_ && null != this.parentStatementSet_.getPackage() && this.parentStatementSet_.getPackage().isBindable() && null != (arrayList = this.parentStatementSet_.getStatements())) {
            for (PDQXmlStatement pDQXmlStatement : arrayList) {
                PDQXmlStatementDescriptor pDQXmlStatementDescriptor;
                int n2 = -1;
                int n3 = 0;
                if (null == pDQXmlStatement || null == (pDQXmlStatementDescriptor = pDQXmlStatement.getPDQXmlStatementDescriptor())) continue;
                n2 = pDQXmlStatementDescriptor.getSectionNumber();
                n3 = pDQXmlStatement.getNumReservedSections();
                if (0 < n2) {
                    this.greatestSectionNumberUsed_ = Math.max(this.greatestSectionNumberUsed_, n2 + n3);
                    continue;
                }
                PDQXmlStatementAttributes pDQXmlStatementAttributes = pDQXmlStatementDescriptor.getStatementAttributes();
                if (null != pDQXmlStatementAttributes && !pDQXmlStatementAttributes.isBindable()) continue;
                this.greatestSectionNumberUsed_ = 0;
                break;
            }
        }
    }

    public ArrayList<PDQXmlStatement> getStatements() {
        if (this.parentStatementSet_ != null) {
            return this.parentStatementSet_.getStatements();
        }
        return null;
    }

    public String getBindOptions() {
        return this.bindOptions_;
    }

    public void setBindOptions(String string) {
        this.bindOptions_ = string;
    }

    @Override
    public String getXml(int n2) {
        XmlBuf xmlBuf = new XmlBuf(n2);
        xmlBuf.startElement("package");
        xmlBuf.addAttrib("name", this.packageName_);
        if (0L != this.consistencyToken_) {
            this.setGreatestSectionNumberUsedBasedOnAssignedSectionNumbersAndReservedSections();
            xmlBuf.addAttrib("consistencyToken", StatementDescriptorImpl.getTimestampAsString(this.consistencyToken_));
            xmlBuf.addAttrib("greatestSectionNumberUsed", this.greatestSectionNumberUsed_);
        }
        if (this.collectionName_ != null) {
            xmlBuf.addAttrib("collection", this.collectionName_);
        } else {
            xmlBuf.addAttrib("collection", "NULLID");
        }
        xmlBuf.addAttrib("version", this.packageVersion_);
        xmlBuf.addAttrib("bindOptions", this.bindOptions_);
        xmlBuf.addAttrib("isBindable", Boolean.valueOf(this.bindable_).toString());
        xmlBuf.addAttrib("isDDLPackage", Boolean.valueOf(this.ddlPackage_).toString());
        xmlBuf.addAttrib("forceSingleBindIsolation", Boolean.valueOf(this.forceSingleBindIsolation_).toString());
        xmlBuf.endElement();
        return xmlBuf.toString();
    }

    public boolean isBindable() {
        return this.bindable_;
    }

    public void setBindable(boolean bl2) {
        this.bindable_ = bl2;
    }

    public boolean isForceSingleBindIsolation() {
        return this.forceSingleBindIsolation_;
    }

    public void setForceSingleBindIsolation(boolean bl2) {
        this.forceSingleBindIsolation_ = bl2;
    }
}

