/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.util.BitSet;
import java.util.Calendar;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.plugin.Codec;

public class BitSetCodec
implements Codec<BitSet> {
    public static final BitSetCodec INSTANCE = new BitSetCodec();

    public static BitSet parseBit(ReadableByteBuf buf, MutableInt length) {
        byte[] arr = new byte[length.get()];
        buf.readBytes(arr);
        BitSetCodec.revertOrder(arr);
        return BitSet.valueOf(arr);
    }

    public static void revertOrder(byte[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    @Override
    public String className() {
        return BitSet.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.BIT && type.isAssignableFrom(BitSet.class);
    }

    @Override
    public BitSet decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) {
        return BitSetCodec.parseBit(buf, length);
    }

    @Override
    public BitSet decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) {
        return BitSetCodec.parseBit(buf, length);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof BitSet;
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long length) throws IOException {
        byte[] bytes = ((BitSet)value).toByteArray();
        BitSetCodec.revertOrder(bytes);
        StringBuilder sb = new StringBuilder(bytes.length * 8 + 3);
        sb.append("b'");
        for (int i = 0; i < 8 * bytes.length; ++i) {
            sb.append((bytes[i / 8] << i % 8 & 0x80) == 0 ? (char)'0' : '1');
        }
        sb.append("'");
        encoder.writeAscii(sb.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        byte[] bytes = ((BitSet)value).toByteArray();
        BitSetCodec.revertOrder(bytes);
        encoder.writeLength(bytes.length);
        encoder.writeBytes(bytes);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

