/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version12;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.version11.V11Database;

public class V12Database
extends V11Database {
    protected V12Database(WireDatabaseConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    @Override
    public void cancelOperation(int kind) throws SQLException {
        block19: {
            try {
                if (kind == 4) {
                    try {
                        this.closeConnection();
                        break block19;
                    }
                    catch (IOException ioe) {
                        throw new SQLNonTransientConnectionException("Connection abort failed", ioe);
                    }
                }
                this.checkConnected();
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(8);
                    try (XdrOutputStream xdr = new XdrOutputStream(out, 8);){
                        xdr.writeInt(91);
                        xdr.writeInt(kind);
                    }
                    this.wireOperations.writeDirect(out.toByteArray());
                }
                catch (IOException ioe) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ioe).toSQLException();
                }
            }
            catch (SQLException ex) {
                this.exceptionListenerDispatcher.errorOccurred(ex);
                throw ex;
            }
        }
    }

    @Override
    protected Encoding getFilenameEncoding(DatabaseParameterBuffer dpb) {
        return this.getEncodingFactory().getEncodingForFirebirdName("UTF8");
    }
}

