/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionHelper;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptCallback;
import org.firebirdsql.gds.ng.fields.BlrCalculator;
import org.firebirdsql.gds.ng.wire.AbstractFbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireAsynchronousChannel;
import org.firebirdsql.gds.ng.wire.FbWireAttachment;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireStatement;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.gds.ng.wire.GenericResponse;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class V10Database
extends AbstractFbWireDatabase
implements FbWireDatabase {
    private static final Logger log = LoggerFactory.getLogger(V10Database.class);
    private BlrCalculator blrCalculator;

    protected V10Database(WireDatabaseConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    @Override
    public final void attach() throws SQLException {
        try {
            DatabaseParameterBuffer dpb = this.protocolDescriptor.createDatabaseParameterBuffer((WireDatabaseConnection)this.connection);
            this.attachOrCreate(dpb, false);
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    protected final void attachOrCreate(DatabaseParameterBuffer dpb, boolean create) throws SQLException {
        this.checkConnected();
        if (this.isAttached()) {
            throw new SQLException("Already attached to a database");
        }
        try (LockCloseable ignored = this.withLock();){
            try {
                try {
                    this.sendAttachOrCreateToBuffer(dpb, create);
                    this.getXdrOut().flush();
                }
                catch (IOException e) {
                    throw new FbExceptionBuilder().exception(335544727).cause(e).toSQLException();
                }
                try {
                    this.authReceiveResponse(null);
                }
                catch (IOException e) {
                    throw new FbExceptionBuilder().exception(335544726).cause(e).toSQLException();
                }
            }
            catch (SQLException e) {
                this.safelyDetach();
                throw e;
            }
            this.setAttached();
            this.afterAttachActions();
        }
    }

    protected final void sendAttachOrCreateToBuffer(DatabaseParameterBuffer dpb, boolean create) throws SQLException, IOException {
        int operation = create ? 20 : 19;
        XdrOutputStream xdrOut = this.getXdrOut();
        Encoding filenameEncoding = this.getFilenameEncoding(dpb);
        xdrOut.writeInt(operation);
        xdrOut.writeInt(0);
        xdrOut.writeString(((WireDatabaseConnection)this.connection).getAttachObjectName(), filenameEncoding);
        xdrOut.writeTyped(dpb);
    }

    protected Encoding getFilenameEncoding(DatabaseParameterBuffer dpb) {
        String filenameCharset = this.getConnectionProperties().getProperty("filename_charset");
        if (filenameCharset != null) {
            return this.getEncodingFactory().getOrCreateEncodingForCharset(Charset.forName(filenameCharset));
        }
        return this.getEncoding();
    }

    protected final void processAttachOrCreateResponse(GenericResponse genericResponse) {
    }

    protected final void afterAttachActions() throws SQLException {
        ((WireDatabaseConnection)this.connection).clearAuthData();
        this.getDatabaseInfo(this.getDescribeDatabaseInfoBlock(), 1024, this.getDatabaseInformationProcessor());
        ((WireDatabaseConnection)this.connection).resetSocketTimeout();
    }

    @Override
    protected final void internalDetach() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            try {
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    if (this.isAttached()) {
                        xdrOut.writeInt(21);
                        xdrOut.writeInt(this.getHandle());
                    }
                    xdrOut.writeInt(6);
                    xdrOut.flush();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                if (this.isAttached()) {
                    try {
                        this.wireOperations.readResponse(null);
                    }
                    catch (IOException ex) {
                        throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                    }
                }
                try {
                    this.closeConnection();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
            }
            catch (SQLException ex) {
                try {
                    this.closeConnection();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                this.setDetached();
            }
        }
    }

    @Override
    public final void createDatabase() throws SQLException {
        try {
            DatabaseParameterBuffer dpb = this.protocolDescriptor.createDatabaseParameterBuffer((WireDatabaseConnection)this.connection);
            this.attachOrCreate(dpb, true);
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dropDatabase() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkAttached();
            try {
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(81);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.flush();
                }
                catch (IOException ioex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ioex).toSQLException();
                }
                try {
                    this.readResponse(null);
                }
                catch (IOException ioex) {
                    throw new FbExceptionBuilder().exception(335544726).cause(ioex).toSQLException();
                }
            }
            finally {
                try {
                    this.closeConnection();
                }
                catch (IOException e) {
                    log.debug("Ignored exception on connection close in dropDatabase()", e);
                }
            }
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final FbWireTransaction startTransaction(TransactionParameterBuffer tpb) throws SQLException {
        try {
            Throwable throwable = null;
            try (LockCloseable ignored = this.withLock();){
                this.checkAttached();
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(29);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeTyped(tpb);
                    xdrOut.flush();
                }
                catch (IOException ioex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ioex).toSQLException();
                }
                try {
                    GenericResponse response = this.readGenericResponse(null);
                    FbWireTransaction transaction = this.protocolDescriptor.createTransaction(this, response.getObjectHandle(), TransactionState.ACTIVE);
                    this.transactionAdded(transaction);
                    FbWireTransaction fbWireTransaction = transaction;
                    return fbWireTransaction;
                }
                catch (IOException ioex) {
                    try {
                        throw new FbExceptionBuilder().exception(335544726).cause(ioex).toSQLException();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final FbTransaction reconnectTransaction(long transactionId) throws SQLException {
        try {
            Throwable throwable = null;
            try (LockCloseable ignored = this.withLock();){
                this.checkAttached();
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(33);
                    xdrOut.writeInt(this.getHandle());
                    byte[] transactionIdBuffer = this.getTransactionIdBuffer(transactionId);
                    xdrOut.writeBuffer(transactionIdBuffer);
                    xdrOut.flush();
                }
                catch (IOException ioex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ioex).toSQLException();
                }
                try {
                    GenericResponse response = this.readGenericResponse(null);
                    FbWireTransaction transaction = this.protocolDescriptor.createTransaction(this, response.getObjectHandle(), TransactionState.PREPARED);
                    this.transactionAdded(transaction);
                    FbWireTransaction fbWireTransaction = transaction;
                    return fbWireTransaction;
                }
                catch (IOException ioex) {
                    try {
                        throw new FbExceptionBuilder().exception(335544726).cause(ioex).toSQLException();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    protected byte[] getTransactionIdBuffer(long transactionId) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4);
        try {
            VaxEncoding.encodeVaxIntegerWithoutLength(bos, (int)transactionId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    @Override
    public final FbStatement createStatement(FbTransaction transaction) throws SQLException {
        try {
            this.checkAttached();
            FbWireStatement stmt = this.protocolDescriptor.createStatement(this);
            stmt.addExceptionListener(this.exceptionListenerDispatcher);
            stmt.setTransaction(transaction);
            return stmt;
        }
        catch (SQLException ex) {
            this.exceptionListenerDispatcher.errorOccurred(ex);
            throw ex;
        }
    }

    @Override
    public void cancelOperation(int kind) throws SQLException {
        block5: {
            try {
                if (kind == 4) {
                    try {
                        this.closeConnection();
                        break block5;
                    }
                    catch (IOException ioe) {
                        throw new SQLNonTransientConnectionException("Connection abort failed", ioe);
                    }
                }
                throw new SQLFeatureNotSupportedException(String.format("Cancel Operation isn't supported in this version of the wire protocol (%d).", this.protocolDescriptor.getVersion()), "0A000");
            }
            catch (SQLException ex) {
                this.exceptionListenerDispatcher.errorOccurred(ex);
                throw ex;
            }
        }
    }

    @Override
    public final void executeImmediate(String statementText, FbTransaction transaction) throws SQLException {
        try {
            if (this.isAttached()) {
                if (transaction == null) {
                    throw FbExceptionBuilder.forException(337248270).toSQLException();
                }
                TransactionHelper.checkTransactionActive(transaction);
            } else if (transaction != null) {
                throw FbExceptionBuilder.forException(337248271).toSQLException();
            }
            try (LockCloseable ignored = this.withLock();){
                try {
                    XdrOutputStream xdrOut = this.getXdrOut();
                    xdrOut.writeInt(64);
                    xdrOut.writeInt(transaction != null ? transaction.getHandle() : 0);
                    xdrOut.writeInt(this.getHandle());
                    xdrOut.writeInt(this.getConnectionDialect());
                    xdrOut.writeString(statementText, this.getEncoding());
                    xdrOut.writeBuffer(null);
                    xdrOut.writeInt(0);
                    this.getXdrOut().flush();
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
                }
                try {
                    if (!this.isAttached()) {
                        this.processAttachOrCreateResponse(this.readGenericResponse(null));
                    }
                    this.readGenericResponse(null);
                }
                catch (IOException ex) {
                    throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
                }
            }
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public void releaseObject(int operation, int objectId) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkAttached();
            try {
                this.doReleaseObjectPacket(operation, objectId);
                this.getXdrOut().flush();
            }
            catch (IOException ex) {
                throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
            }
            try {
                this.processReleaseObjectResponse(this.readResponse(null));
            }
            catch (IOException ex) {
                throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
            }
        }
    }

    @Override
    public final FbWireAsynchronousChannel initAsynchronousChannel() throws SQLException {
        int port;
        int auxHandle;
        this.checkAttached();
        try (LockCloseable ignored = this.withLock();){
            try {
                XdrOutputStream xdrOut = this.getXdrOut();
                xdrOut.writeInt(53);
                xdrOut.writeInt(1);
                xdrOut.writeInt(this.getHandle());
                xdrOut.writeInt(0);
                xdrOut.flush();
            }
            catch (IOException ex) {
                throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
            }
            try {
                GenericResponse response = this.readGenericResponse(null);
                auxHandle = response.getObjectHandle();
                byte[] data = response.getData();
                port = ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
            }
            catch (IOException ex) {
                throw new FbExceptionBuilder().exception(335544726).cause(ex).toSQLException();
            }
        }
        FbWireAsynchronousChannel channel = this.protocolDescriptor.createAsynchronousChannel(this);
        channel.connect(((WireDatabaseConnection)this.connection).getServerName(), port, auxHandle);
        return channel;
    }

    protected final void doReleaseObjectPacket(int operation, int objectId) throws IOException, SQLException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(operation);
        xdrOut.writeInt(objectId);
    }

    protected final void processReleaseObjectResponse(Response response) {
    }

    @Override
    public final BlrCalculator getBlrCalculator() {
        if (this.blrCalculator == null) {
            this.blrCalculator = this.protocolDescriptor.createBlrCalculator(this);
        }
        return this.blrCalculator;
    }

    @Override
    public final void authReceiveResponse(FbWireAttachment.AcceptPacket acceptPacket) throws IOException, SQLException {
        DbCryptCallback dbCryptCallback = ((WireDatabaseConnection)this.connection).createDbCryptCallback();
        this.wireOperations.authReceiveResponse(acceptPacket, dbCryptCallback, this::processAttachOrCreateResponse);
    }
}

