/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.obofoundry;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.obofoundry.OboFoundryEntry;
import org.protege.editor.owl.model.obofoundry.OboFoundryLink;
import org.protege.editor.owl.model.obofoundry.OboFoundryRegistry;
import org.protege.editor.owl.model.obofoundry.OboFoundryRegistryManager;
import org.protege.editor.owl.model.util.OboUtilities;
import org.protege.editor.owl.ui.renderer.LinkExtractor;
import org.protege.editor.owl.ui.renderer.layout.Link;

public class OboFoundryLinkExtractor
implements LinkExtractor {
    @Nonnull
    private final OboFoundryRegistry registry;

    public OboFoundryLinkExtractor(@Nonnull OboFoundryRegistry registry) {
        this.registry = (OboFoundryRegistry)Preconditions.checkNotNull((Object)registry);
    }

    public static OboFoundryLinkExtractor createLinkExtractor() {
        return new OboFoundryLinkExtractor(OboFoundryRegistryManager.getRegistry());
    }

    @Override
    public Optional<Link> extractLink(String s) {
        String trimmed = s.trim();
        if (!OboUtilities.isOboId(s)) {
            return Optional.empty();
        }
        String[] parts = trimmed.split(":");
        if (parts.length != 2) {
            return Optional.empty();
        }
        String lowerCasePrefix = parts[0].toLowerCase();
        return this.registry.getOntology(lowerCasePrefix).map(e -> new OboFoundryLink(s, OboUtilities.getOboLibraryIriFromOboId(trimmed), (OboFoundryEntry)e));
    }
}

