/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.identity;

import java.security.Principal;
import java.util.concurrent.Callable;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.identity.NamedPrincipal;
import org.opensearch.identity.PluginSubject;
import org.opensearch.threadpool.ThreadPool;

public class NoopPluginSubject
implements PluginSubject {
    private final ThreadPool threadPool;

    public NoopPluginSubject(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public Principal getPrincipal() {
        return NamedPrincipal.UNAUTHENTICATED;
    }

    public <T> T runAs(Callable<T> callable) throws Exception {
        try (ThreadContext.StoredContext ctx = this.threadPool.getThreadContext().stashContext();){
            T t = callable.call();
            return t;
        }
    }
}

